/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.lifecycle;

import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpSession;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class RequestCounter
implements SerializableCompatibility {
    private static final String ATTR_INSTANCE = String.valueOf(RequestCounter.class.getName()) + "#instance";
    private static final String PROP_REQUEST_COUNTER = "requestCounter";
    private final AtomicInteger requestId = new AtomicInteger();

    private RequestCounter() {
    }

    public static RequestCounter getInstance() {
        HttpSession httpSession = ContextProvider.getUISession().getHttpSession();
        RequestCounter result = (RequestCounter)httpSession.getAttribute(ATTR_INSTANCE);
        if (result == null) {
            result = new RequestCounter();
            httpSession.setAttribute(ATTR_INSTANCE, (Object)result);
        }
        return result;
    }

    public static void reattachToHttpSession(HttpSession httpSession) {
        Object value = httpSession.getAttribute(ATTR_INSTANCE);
        httpSession.setAttribute(ATTR_INSTANCE, value);
    }

    public boolean isValid() {
        String sentRequestId = ProtocolUtil.readHeadPropertyValue(PROP_REQUEST_COUNTER);
        if (sentRequestId == null) {
            return this.requestId.get() == 0;
        }
        return this.requestId.toString().equals(sentRequestId);
    }

    public int nextRequestId() {
        return this.requestId.incrementAndGet();
    }

    public int currentRequestId() {
        return this.requestId.get();
    }
}

