/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.protocol;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.ParamCheck;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientMessage {
    public static final String PROP_HEAD = "head";
    public static final String PROP_OPERATIONS = "operations";
    public static final String OPERATION_SET = "set";
    public static final String OPERATION_NOTIFY = "notify";
    public static final String OPERATION_CALL = "call";
    private final JSONObject message;
    private final JSONObject head;
    private final HashMap<String, List<Operation>> operationsMap;
    private final List<Operation> operationsList;

    public ClientMessage(String json) {
        JSONArray operations;
        ParamCheck.notNull(json, "json");
        try {
            this.message = new JSONObject(json);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Could not parse json message: " + json);
        }
        try {
            this.head = this.message.getJSONObject(PROP_HEAD);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Missing header object: " + json);
        }
        try {
            operations = this.message.getJSONArray(PROP_OPERATIONS);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Missing operations array: " + json);
        }
        try {
            this.operationsMap = new HashMap();
            this.operationsList = new ArrayList<Operation>();
            this.processOperations(operations);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Invalid operations array: " + json);
        }
    }

    public Operation[] getAllOperations() {
        return this.operationsList.toArray(new Operation[0]);
    }

    public Operation[] getAllOperationsFor(String target) {
        return this.getOperations(Operation.class, target, null);
    }

    public SetOperation getLastSetOperationFor(String target, String property) {
        SetOperation result = null;
        SetOperation[] operations = this.getOperations(SetOperation.class, target, property);
        if (operations.length > 0) {
            result = operations[operations.length - 1];
        }
        return result;
    }

    public NotifyOperation getLastNotifyOperationFor(String target, String eventName) {
        List<Operation> operations;
        NotifyOperation result = null;
        List<Operation> list = operations = target == null ? this.operationsList : this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation instanceof NotifyOperation)) continue;
                NotifyOperation currentOperation = (NotifyOperation)operation;
                if (eventName != null && !currentOperation.getEventName().equals(eventName)) continue;
                result = currentOperation;
            }
        }
        return result;
    }

    public CallOperation[] getAllCallOperationsFor(String target, String methodName) {
        List<Operation> operations;
        ArrayList<CallOperation> result = new ArrayList<CallOperation>();
        List<Operation> list = operations = target == null ? this.operationsList : this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!(operation instanceof CallOperation)) continue;
                CallOperation currentOperation = (CallOperation)operation;
                if (methodName != null && !currentOperation.getMethodName().equals(methodName)) continue;
                result.add(currentOperation);
            }
        }
        return result.toArray(new CallOperation[0]);
    }

    public Object getHeadProperty(String key) {
        Object result = null;
        try {
            result = this.head.get(key);
        }
        catch (JSONException jSONException) {}
        return result;
    }

    public String toString() {
        try {
            return this.message.toString(2);
        }
        catch (JSONException jSONException) {
            throw new RuntimeException("Formatting failed");
        }
    }

    private void processOperations(JSONArray operations) throws JSONException {
        int i = 0;
        while (i < operations.length()) {
            Operation operation = this.createOperation(operations.getJSONArray(i));
            this.appendOperation(operation);
            ++i;
        }
    }

    private Operation createOperation(JSONArray data) {
        Operation result = null;
        String action = this.getOperationAction(data);
        if (action.equals(OPERATION_SET)) {
            result = new SetOperation(data);
        } else if (action.equals(OPERATION_NOTIFY)) {
            result = new NotifyOperation(data);
        } else if (action.equals(OPERATION_CALL)) {
            result = new CallOperation(data);
        } else {
            throw new IllegalArgumentException("Unknown operation action: " + action);
        }
        return result;
    }

    private void appendOperation(Operation operation) {
        String target = operation.getTarget();
        List<Operation> targetOperations = this.operationsMap.get(target);
        if (targetOperations == null) {
            targetOperations = new ArrayList<Operation>();
        }
        targetOperations.add(operation);
        this.operationsMap.put(target, targetOperations);
        this.operationsList.add(operation);
    }

    private String getOperationAction(JSONArray operation) {
        String result;
        try {
            result = operation.getString(0);
        }
        catch (JSONException jSONException) {
            throw new IllegalArgumentException("Could not find action for operation " + operation);
        }
        return result;
    }

    private <T> T[] getOperations(Class<T> opClass, String target, String property) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        List<Operation> operations = this.operationsMap.get(target);
        if (operations != null) {
            for (Operation operation : operations) {
                if (!opClass.isInstance(operation) || property != null && !operation.getPropertyNames().contains(property)) continue;
                result.add(operation);
            }
        }
        return result.toArray((Object[])Array.newInstance(opClass, 0));
    }

    public final class CallOperation
    extends Operation {
        private final String methodName;
        private final JSONObject properties;

        private CallOperation(JSONArray operation) {
            super(operation);
            try {
                this.methodName = operation.getString(2);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Method name missing in operation", e);
            }
            try {
                this.properties = operation.getJSONObject(3);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        public String getMethodName() {
            return this.methodName;
        }

        protected JSONObject getProperties() {
            return this.properties;
        }
    }

    public final class NotifyOperation
    extends Operation {
        private final String eventName;
        private final JSONObject properties;

        private NotifyOperation(JSONArray operation) {
            super(operation);
            try {
                this.eventName = operation.getString(2);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Event type missing in operation", e);
            }
            try {
                this.properties = operation.getJSONObject(3);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        public String getEventName() {
            return this.eventName;
        }

        protected JSONObject getProperties() {
            return this.properties;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class Operation {
        private final String target;

        private Operation(JSONArray operation) {
            try {
                this.target = operation.getString(1);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Invalid operation target", e);
            }
        }

        public String getTarget() {
            return this.target;
        }

        public List<String> getPropertyNames() {
            JSONObject properties = this.getProperties();
            String[] names = JSONObject.getNames(properties);
            return names == null ? Collections.EMPTY_LIST : Arrays.asList(names);
        }

        public Object getProperty(String key) {
            Object result = null;
            JSONObject properties = this.getProperties();
            try {
                Object value = properties.get(key);
                result = value instanceof JSONObject ? JsonUtil.jsonToJava((JSONObject)value) : (value instanceof JSONArray ? JsonUtil.jsonToJava((JSONArray)value) : value);
            }
            catch (JSONException jSONException) {}
            return result;
        }

        protected abstract JSONObject getProperties();
    }

    public final class SetOperation
    extends Operation {
        private final JSONObject properties;

        private SetOperation(JSONArray operation) {
            super(operation);
            try {
                this.properties = operation.getJSONObject(2);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("Properties object missing in operation", e);
            }
        }

        protected JSONObject getProperties() {
            return this.properties;
        }
    }
}

