/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.internal.protocol.ClientMessage;
import org.eclipse.rap.rwt.internal.protocol.ProtocolMessageWriter;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectRegistry;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.remote.OperationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObjectLifeCycleAdapter {
    public static void render() {
        RemoteObjectRegistry registry = RemoteObjectRegistry.getInstance();
        ProtocolMessageWriter writer = ContextProvider.getProtocolWriter();
        for (RemoteObjectImpl remoteObject : registry.getRemoteObjects()) {
            remoteObject.render(writer);
        }
    }

    public static void readData() {
        RemoteObjectRegistry registry = RemoteObjectRegistry.getInstance();
        for (RemoteObjectImpl remoteObject : registry.getRemoteObjects()) {
            RemoteObjectLifeCycleAdapter.dispatchOperations(remoteObject);
        }
    }

    private static void dispatchOperations(RemoteObjectImpl remoteObject) {
        List<ClientMessage.Operation> operations = RemoteObjectLifeCycleAdapter.getOperations(remoteObject);
        if (!operations.isEmpty()) {
            OperationHandler handler = RemoteObjectLifeCycleAdapter.getHandler(remoteObject);
            for (ClientMessage.Operation operation : operations) {
                RemoteObjectLifeCycleAdapter.dispatchOperation(handler, operation);
            }
        }
    }

    public static OperationHandler getHandler(RemoteObjectImpl remoteObject) {
        OperationHandler handler = remoteObject.getHandler();
        if (handler == null) {
            String message = "No operation handler registered for remote object: " + remoteObject.getId();
            throw new UnsupportedOperationException(message);
        }
        return handler;
    }

    private static List<ClientMessage.Operation> getOperations(RemoteObjectImpl remoteObject) {
        ClientMessage message = ProtocolUtil.getClientMessage();
        ClientMessage.Operation[] operations = message.getAllOperationsFor(remoteObject.getId());
        return Arrays.asList(operations);
    }

    public static void dispatchOperation(OperationHandler handler, ClientMessage.Operation operation) {
        if (operation instanceof ClientMessage.SetOperation) {
            handler.handleSet(RemoteObjectLifeCycleAdapter.getProperties(operation));
        } else if (operation instanceof ClientMessage.CallOperation) {
            ClientMessage.CallOperation callOperation = (ClientMessage.CallOperation)operation;
            handler.handleCall(callOperation.getMethodName(), RemoteObjectLifeCycleAdapter.getProperties(operation));
        } else if (operation instanceof ClientMessage.NotifyOperation) {
            ClientMessage.NotifyOperation notifyOperation = (ClientMessage.NotifyOperation)operation;
            RemoteObjectLifeCycleAdapter.scheduleHandleNotify(handler, notifyOperation.getEventName(), RemoteObjectLifeCycleAdapter.getProperties(operation));
        }
    }

    private static void scheduleHandleNotify(final OperationHandler handler, final String event, final Map<String, Object> properties) {
        ProcessActionRunner.add(new Runnable(){

            public void run() {
                handler.handleNotify(event, properties);
            }
        });
    }

    private static Map<String, Object> getProperties(ClientMessage.Operation operation) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> propertyNames = operation.getPropertyNames();
        for (String name : propertyNames) {
            result.put(name, operation.getProperty(name));
        }
        return result;
    }
}

