/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import org.eclipse.rap.rwt.internal.theme.JsonValue;

public final class JsonObject
extends JsonValue {
    private final StringBuilder buffer = new StringBuilder();
    private int count = 0;

    public JsonObject() {
        this.buffer.append("{");
    }

    public void append(String key, int value) {
        this.append(key, JsonObject.valueOf(value));
    }

    public void append(String key, float value) {
        this.append(key, JsonObject.valueOf(value));
    }

    public void append(String key, boolean value) {
        this.append(key, JsonObject.valueOf(value));
    }

    public void append(String key, String value) {
        this.append(key, JsonObject.valueOf(value));
    }

    public void append(String key, JsonValue value) {
        if (value != null) {
            this.doAppend(key, value.toString());
        } else {
            this.doAppend(key, "null");
        }
    }

    public String toString() {
        String tail = this.count == 0 ? "}" : "\n}";
        return String.valueOf(this.buffer.toString()) + tail;
    }

    private void doAppend(String key, String valueStr) {
        this.buffer.append(this.count == 0 ? "\n" : ",\n");
        JsonObject.appendQuotedAndEscapedString(this.buffer, key);
        this.buffer.append(": ");
        this.buffer.append(valueStr);
        ++this.count;
    }
}

