/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.listkit;

import java.io.IOException;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class ListLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.List";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "BORDER"};
    private static final String PROP_ITEMS = "items";
    private static final String PROP_SELECTION_INDICES = "selectionIndices";
    private static final String PROP_TOP_INDEX = "topIndex";
    private static final String PROP_FOCUS_INDEX = "focusIndex";
    private static final String PROP_ITEM_DIMENSIONS = "itemDimensions";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final int[] DEFAUT_SELECTION_INDICES = new int[0];
    private static final int DEFAULT_TOP_INDEX = 0;
    private static final int DEFAULT_FOCUS_INDEX = -1;
    private static final Point DEFAULT_ITEM_DIMENSIONS = new Point(0, 0);

    public void preserveValues(Widget widget) {
        List list = (List)widget;
        ControlLCAUtil.preserveValues(list);
        WidgetLCAUtil.preserveCustomVariant(list);
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_ITEMS, list.getItems());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_SELECTION_INDICES, list.getSelectionIndices());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_TOP_INDEX, list.getTopIndex());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_FOCUS_INDEX, list.getFocusIndex());
        WidgetLCAUtil.preserveProperty((Widget)list, PROP_ITEM_DIMENSIONS, ListLCA.getItemDimensions(list));
        WidgetLCAUtil.preserveListener(list, PROP_SELECTION_LISTENER, list.isListening(13));
        WidgetLCAUtil.preserveListener(list, PROP_DEFAULT_SELECTION_LISTENER, list.isListening(14));
        ScrollBarLCAUtil.preserveValues(list);
    }

    public void readData(Widget widget) {
        List list = (List)widget;
        ListLCA.readTopIndex(list);
        ListLCA.readSelection(list);
        ListLCA.readFocusIndex(list);
        ControlLCAUtil.processSelection(list, null, true);
        ControlLCAUtil.processDefaultSelection(list, null);
        ControlLCAUtil.processEvents(list);
        ControlLCAUtil.processKeyEvents(list);
        ControlLCAUtil.processMenuDetect(list);
        WidgetLCAUtil.processHelp(list);
        ScrollBarLCAUtil.processSelectionEvent(list);
    }

    public void renderInitialization(Widget widget) throws IOException {
        List list = (List)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(list);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(list.getParent()));
        clientObject.set("style", WidgetLCAUtil.getStyles(list, ALLOWED_STYLES));
        clientObject.set(PROP_MARKUP_ENABLED, ListLCA.isMarkupEnabled(list));
        ScrollBarLCAUtil.renderInitialization(list);
    }

    public void renderChanges(Widget widget) throws IOException {
        List list = (List)widget;
        ControlLCAUtil.renderChanges(list);
        WidgetLCAUtil.renderCustomVariant(list);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_ITEMS, list.getItems(), DEFAUT_ITEMS);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_SELECTION_INDICES, list.getSelectionIndices(), DEFAUT_SELECTION_INDICES);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_TOP_INDEX, list.getTopIndex(), 0);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_FOCUS_INDEX, list.getFocusIndex(), -1);
        WidgetLCAUtil.renderListener(list, PROP_SELECTION_LISTENER, list.isListening(13), false);
        WidgetLCAUtil.renderListener(list, PROP_DEFAULT_SELECTION_LISTENER, list.isListening(14), false);
        WidgetLCAUtil.renderProperty((Widget)list, PROP_ITEM_DIMENSIONS, ListLCA.getItemDimensions(list), DEFAULT_ITEM_DIMENSIONS);
        ScrollBarLCAUtil.renderChanges(list);
    }

    private static void readSelection(List list) {
        int[] value = ProtocolUtil.readPropertyValueAsIntArray(WidgetUtil.getId(list), "selection");
        if (value != null) {
            list.setSelection(value);
        }
    }

    private static void readTopIndex(List list) {
        String value = WidgetLCAUtil.readPropertyValue(list, PROP_TOP_INDEX);
        if (value != null) {
            list.setTopIndex(NumberFormatUtil.parseInt(value));
        }
    }

    private static void readFocusIndex(List list) {
        String paramValue = WidgetLCAUtil.readPropertyValue(list, PROP_FOCUS_INDEX);
        if (paramValue != null) {
            int focusIndex = NumberFormatUtil.parseInt(paramValue);
            ListLCA.getAdapter(list).setFocusIndex(focusIndex);
        }
    }

    private static boolean isMarkupEnabled(List list) {
        return Boolean.TRUE.equals(list.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static Point getItemDimensions(List list) {
        return ListLCA.getAdapter(list).getItemDimensions();
    }

    private static IListAdapter getAdapter(List list) {
        return list.getAdapter(IListAdapter.class);
    }
}

