/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    private ScrollBar verticalBar;
    private ScrollBar horizontalBar;

    Scrollable(Composite parent) {
        super(parent);
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
        this.createScrollBars();
    }

    private void createScrollBars() {
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = new ScrollBar(this, 256);
            this.horizontalBar.setVisible(false);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = new ScrollBar(this, 512);
            this.verticalBar.setVisible(false);
        }
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle bounds = this.getBounds();
        int borderWidth = this.getBorderWidth();
        Rectangle padding = this.getPadding();
        int width = bounds.width - borderWidth * 2 - padding.width - this.getVScrollBarWidth();
        int height = bounds.height - borderWidth * 2 - padding.height - this.getHScrollBarHeight();
        return new Rectangle(padding.x, padding.y, Math.max(0, width), Math.max(0, height));
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int borderWidth = this.getBorderWidth();
        Rectangle padding = this.getPadding();
        int newWidth = width + borderWidth * 2 + padding.width + this.getVScrollBarWidth();
        int newHeight = height + borderWidth * 2 + padding.height + this.getHScrollBarHeight();
        int newX = x - borderWidth - padding.x;
        int newY = y - borderWidth - padding.y;
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseChildren() {
        super.releaseChildren();
        if (this.verticalBar != null) {
            this.verticalBar.dispose();
        }
        if (this.horizontalBar != null) {
            this.horizontalBar.dispose();
        }
    }

    int getVScrollBarWidth() {
        int result = 0;
        if (this.verticalBar != null && this.verticalBar.getVisible()) {
            result = this.verticalBar.getSize().x;
        }
        return result;
    }

    int getHScrollBarHeight() {
        int result = 0;
        if (this.horizontalBar != null && this.horizontalBar.getVisible()) {
            result = this.horizontalBar.getSize().y;
        }
        return result;
    }
}

