/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.internal.theme.IThemeAdapter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.FontUtil;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.internal.widgets.combokit.ComboThemeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;
    private static final int LIST_ITEM_PADDING = 3;
    private static final double LINE_HEIGHT_FACTOR = 1.2;
    private final ListModel model;
    private String text = "";
    private int textLimit = Integer.MAX_VALUE;
    private int visibleCount = 5;
    private final Point selection = new Point(0, 0);
    private boolean dropped = false;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
        this.model = new ListModel(true);
    }

    void initState() {
        this.state &= 0xFFFFFEFF;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public void select(int selectionIndex) {
        this.checkWidget();
        if (selectionIndex >= 0 && selectionIndex < this.getItemCount()) {
            this.model.setSelection(selectionIndex);
            this.updateText();
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index == this.model.getSelectionIndex()) {
            this.model.setSelection(-1);
        }
        this.updateText();
    }

    public void deselectAll() {
        this.checkWidget();
        this.model.deselectAll();
        this.text = "";
        this.sendModifyEvent();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error(4);
        }
        int validatedStart = this.selection.x;
        int validatedEnd = this.selection.y;
        int start = selection.x;
        int end = selection.y;
        if (start >= 0 && end >= start) {
            validatedStart = Math.min(start, this.text.length());
            validatedEnd = Math.min(end, this.text.length());
        } else if (end >= 0 && start > end) {
            validatedStart = Math.min(end, this.text.length());
            validatedEnd = Math.min(start, this.text.length());
        }
        this.selection.x = validatedStart;
        this.selection.y = validatedEnd;
    }

    public Point getSelection() {
        this.checkWidget();
        return new Point(this.selection.x, this.selection.y);
    }

    public void clearSelection() {
        this.checkWidget();
        this.selection.x = 0;
        this.selection.y = 0;
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
    }

    public void remove(int index) {
        this.checkWidget();
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == index) {
            this.deselect(index);
        }
        this.model.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        String[] items = this.model.getItems();
        int lastIndex = items.length - 1;
        if (start < 0 || start > lastIndex || end < 0 || end > lastIndex || end < start) {
            this.error(6);
        }
        int selectionIndex = this.getSelectionIndex();
        int i = start;
        while (i <= end) {
            int index = this.indexOf(items[i]);
            if (selectionIndex == index) {
                this.deselect(index);
            }
            ++i;
        }
        this.model.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        int indexOfThisString = this.indexOf(string);
        int selectionIndex = this.getSelectionIndex();
        if (selectionIndex == indexOfThisString) {
            this.deselect(indexOfThisString);
        }
        this.model.remove(string);
    }

    public void removeAll() {
        this.checkWidget();
        this.deselectAll();
        this.model.removeAll();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.model.setItem(index, string);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.model.setItems(items);
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        int charHeight = TextSizeUtil.getCharHeight(this.getFont());
        int padding = 6;
        return charHeight + padding;
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count >= 0) {
            this.visibleCount = count;
        }
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
        this.dropped = visible;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.dropped;
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        return this.model.indexOf(string, start);
    }

    public String getText() {
        this.checkWidget();
        String result = "";
        if ((this.style & 8) != 0) {
            int idx = this.model.getSelectionIndex();
            if (idx != -1) {
                result = this.model.getItem(idx);
            }
        } else {
            result = this.text;
        }
        return result;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int index = this.indexOf(string);
            if (index != -1) {
                this.select(index);
            }
        } else {
            this.internalSetText(string, true);
        }
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.textLimit;
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            this.error(7);
        }
        this.textLimit = limit > 0 ? limit : Integer.MAX_VALUE;
    }

    public int getTextHeight() {
        this.checkWidget();
        Font font = this.getFont();
        int fontSize = FontUtil.getData(font).getHeight();
        return (int)Math.floor((double)fontSize * 1.2);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = TextSizeUtil.getCharHeight(this.getFont());
        if (wHint == -1 || hHint == -1) {
            String[] items = this.model.getItems();
            int i = 0;
            while (i < items.length) {
                if (!"".equals(items[i])) {
                    Point extent = TextSizeUtil.stringExtent(this.getFont(), items[i]);
                    width = Math.max(width, extent.x + 10);
                }
                ++i;
            }
        }
        Rectangle fieldPadding = this.getFieldPadding();
        int buttonWidth = this.getButtonWidth();
        if (width != 0) {
            width += fieldPadding.width + buttonWidth;
        }
        if (height != 0) {
            height += fieldPadding.height;
            height += 2;
        }
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += 2 * border, height += 2 * border);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(13, listener);
        this.removeListener(14, listener);
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.removeListener(24, listener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.removeListener(25, listener);
    }

    boolean isTabGroup() {
        return true;
    }

    String getNameText() {
        return this.getText();
    }

    private void updateText() {
        if ((this.style & 8) == 0) {
            int selectionIndex = this.getSelectionIndex();
            String text = selectionIndex != -1 ? this.getItem(selectionIndex) : "";
            this.internalSetText(text, false);
        } else {
            this.sendModifyEvent();
        }
    }

    private void internalSetText(String text, boolean updateSelection) {
        String verifiedText = this.verifyText(text, 0, this.text.length());
        if (verifiedText != null) {
            if (updateSelection) {
                int index = -1;
                String[] items = this.model.getItems();
                int i = 0;
                while (index == -1 && i < items.length) {
                    if (verifiedText.equals(items[i])) {
                        index = i;
                    }
                    ++i;
                }
                this.model.setSelection(index);
            }
            this.text = verifiedText.length() > this.textLimit ? verifiedText.substring(0, this.textLimit) : verifiedText;
            this.sendModifyEvent();
        }
    }

    private String verifyText(String text, int start, int end) {
        Event event = new Event();
        event.text = text;
        event.start = start;
        event.end = end;
        this.notifyListeners(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        String result = event.text;
        return result;
    }

    private void sendModifyEvent() {
        this.notifyListeners(24, new Event());
    }

    private Rectangle getFieldPadding() {
        ComboThemeAdapter adapter = (ComboThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return adapter.getFieldPadding(this);
    }

    private int getButtonWidth() {
        ComboThemeAdapter adapter = (ComboThemeAdapter)this.getAdapter(IThemeAdapter.class);
        return adapter.getButtonWidth(this);
    }

    private static int checkStyle(int style) {
        int result = style;
        result &= 0xFFFFF7FF;
        result &= 0xFFFFFCFF;
        if (((result = Combo.checkBits(result, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return result & 0xFFFFFFF7;
        }
        return result |= 0x100;
    }
}

