/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ToolBarTab
extends ExampleTab {
    private ToolBar toolBar;
    private ToolItem dropDownItem;
    private int count = 0;

    public ToolBarTab() {
        super("ToolBar");
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("HORIZONTAL", 256);
        this.createStyleButton("VERTICAL", 512);
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("FLAT", 0x800000);
        this.createStyleButton("NO_RADIO_GROUP", 0x400000);
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createFgColorButton();
        this.createBgColorButton();
        this.createBgImageButton();
        this.createFontChooser();
        this.createNewItemButton();
    }

    private void createNewItemButton() {
        Group group = new Group(this.styleComp, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setText("New Item");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Index:");
        final Text index = new Text((Composite)group, 18436);
        index.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        index.setText("0");
        Button addItemButton = new Button((Composite)group, 8);
        GridData gridData = new GridData(1, 0x1000000, false, false);
        gridData.horizontalSpan = 2;
        addItemButton.setLayoutData((Object)gridData);
        addItemButton.setText("Add Item");
        addItemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newIndex = Integer.parseInt(index.getText());
                ToolItem toolItem = new ToolItem(ToolBarTab.this.toolBar, 16, newIndex);
                toolItem.setText("Item");
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        Image imageNewFile = this.loadImage("resources/newfile_wiz.gif");
        Image imagenewFolder = this.loadImage("resources/newfolder_wiz.gif");
        Image imageNewProj = this.loadImage("resources/newprj_wiz.gif");
        Image imageSearch = this.loadImage("resources/search_src.gif");
        this.toolBar = new ToolBar(parent, this.getStyle());
        ToolBarTab.addContextMenu(this.toolBar);
        this.registerControl((Control)this.toolBar);
        ToolItem item1 = new ToolItem(this.toolBar, 8);
        item1.setText("new");
        item1.setImage(imageNewFile);
        ToolItem item2 = new ToolItem(this.toolBar, 8);
        item2.setText("open");
        item2.setEnabled(false);
        item2.setImage(imagenewFolder);
        new ToolItem(this.toolBar, 2);
        this.dropDownItem = new ToolItem(this.toolBar, 4);
        this.dropDownItem.setText("select");
        this.dropDownItem.setImage(imageNewProj);
        new ToolItem(this.toolBar, 2);
        ToolItem itemText = new ToolItem(this.toolBar, 2);
        Text text = new Text((Composite)this.toolBar, 2048);
        text.setText("A Text Field");
        itemText.setControl((Control)text);
        itemText.setWidth(100);
        ToolItem item4 = new ToolItem(this.toolBar, 32);
        item4.setImage(imageSearch);
        item4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolBarTab.this.log("check changed" + event);
            }
        });
        ToolItem item5 = new ToolItem(this.toolBar, 16);
        item5.setImage(imageSearch);
        ToolItem item6 = new ToolItem(this.toolBar, 16);
        SelectionAdapter radioSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ToolBarTab.this.log("radio changed - " + event);
            }
        };
        item6.setImage(imageSearch);
        item5.addSelectionListener((SelectionListener)radioSelectionListener);
        item6.addSelectionListener((SelectionListener)radioSelectionListener);
        final Menu dropDownMenu = new Menu((Decorations)this.toolBar.getShell(), 8);
        int i = 0;
        while (i < 5) {
            MenuItem item = new MenuItem(dropDownMenu, 8);
            item.setText("Item " + this.count++);
            ++i;
        }
        this.dropDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.detail == 4) {
                    Point point = ToolBarTab.this.toolBar.toDisplay(event.x, event.y);
                    dropDownMenu.setLocation(point);
                    dropDownMenu.setVisible(true);
                }
            }
        });
        ToolItem withoutImageIcon = new ToolItem(this.toolBar, 8);
        withoutImageIcon.setText("w/o <image>");
    }

    private static void addContextMenu(ToolBar toolbar) {
        Menu menu = new Menu((Control)toolbar);
        MenuItem item = new MenuItem(menu, 8);
        item.setText("ToolBar context menu item");
        toolbar.setMenu(menu);
    }
}

