/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.remote;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rap.rwt.SingletonUtil;
import org.eclipse.rap.rwt.internal.remote.RemoteObjectImpl;
import org.eclipse.rap.rwt.remote.RemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteObjectRegistry
implements Serializable {
    private final Map<String, RemoteObjectImpl> remoteObjects = new LinkedHashMap<String, RemoteObjectImpl>();

    RemoteObjectRegistry() {
    }

    public static RemoteObjectRegistry getInstance() {
        return SingletonUtil.getSessionInstance(RemoteObjectRegistry.class);
    }

    public void register(RemoteObjectImpl object) {
        String id = object.getId();
        if (this.remoteObjects.containsKey(id)) {
            throw new IllegalArgumentException("Remote object already registered, id: " + id);
        }
        this.remoteObjects.put(id, object);
    }

    public void remove(RemoteObjectImpl object) {
        String id = object.getId();
        if (!this.remoteObjects.containsKey(id)) {
            throw new IllegalArgumentException("Remote object not found in registry, id: " + id);
        }
        this.remoteObjects.remove(id);
    }

    public RemoteObject get(String id) {
        return this.remoteObjects.get(id);
    }

    public List<RemoteObjectImpl> getRemoteObjects() {
        return new ArrayList<RemoteObjectImpl>(this.remoteObjects.values());
    }
}

