/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.linkkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Link";
    private static final String[] ALLOWED_STYLES = new String[]{"BORDER"};
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION_LISTENER = "Selection";

    public void preserveValues(Widget widget) {
        Link link = (Link)widget;
        ControlLCAUtil.preserveValues(link);
        WidgetLCAUtil.preserveCustomVariant(link);
        WidgetLCAUtil.preserveProperty((Widget)link, PROP_TEXT, link.getText());
        WidgetLCAUtil.preserveListener(link, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(link, 13));
    }

    public void readData(Widget widget) {
        Link link = (Link)widget;
        LinkLCA.processSelectionEvent(link);
        ControlLCAUtil.processEvents(link);
        ControlLCAUtil.processKeyEvents(link);
        ControlLCAUtil.processMenuDetect(link);
        WidgetLCAUtil.processHelp(link);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Link link = (Link)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(link);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(link.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(link, ALLOWED_STYLES)));
    }

    public void renderChanges(Widget widget) throws IOException {
        Link link = (Link)widget;
        ControlLCAUtil.renderChanges(link);
        WidgetLCAUtil.renderCustomVariant(link);
        LinkLCA.renderText(link);
        WidgetLCAUtil.renderListener(link, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(link, 13), false);
    }

    private static void renderText(Link link) {
        String newValue = link.getText();
        if (WidgetLCAUtil.hasChanged(link, PROP_TEXT, newValue, "")) {
            ClientObjectFactory.getClientObject(link).set(PROP_TEXT, LinkLCA.getTextObject(link));
        }
    }

    private static JsonArray getTextObject(Link link) {
        ILinkAdapter adapter = link.getAdapter(ILinkAdapter.class);
        String displayText = adapter.getDisplayText();
        Point[] offsets = adapter.getOffsets();
        JsonArray result = new JsonArray();
        int length = displayText.length();
        int pos = 0;
        int i = 0;
        while (i < offsets.length) {
            int start = offsets[i].x;
            int end = offsets[i].y + 1;
            if (pos < start) {
                result.add(new JsonArray().add(displayText.substring(pos, start)).add(JsonObject.NULL));
            }
            if (start < end) {
                result.add(new JsonArray().add(displayText.substring(start, end)).add(i));
            }
            pos = end;
            ++i;
        }
        if (pos < length) {
            result.add(new JsonArray().add(displayText.substring(pos, length)).add(JsonObject.NULL));
        }
        return result;
    }

    private static void processSelectionEvent(Link link) {
        ILinkAdapter adapter;
        String[] ids;
        String value;
        int index;
        String eventName = PROP_SELECTION_LISTENER;
        if (WidgetLCAUtil.wasEventSent(link, eventName) && (index = NumberFormatUtil.parseInt(value = WidgetLCAUtil.readEventPropertyValue(link, eventName, "index"))) < (ids = (adapter = link.getAdapter(ILinkAdapter.class)).getIds()).length) {
            Event event = new Event();
            event.text = ids[index];
            event.stateMask = EventLCAUtil.readStateMask(link, eventName);
            link.notifyListeners(13, event);
        }
    }
}

