/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.CellToolTipUtil;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.internal.widgets.ScrollBarLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCA
extends AbstractWidgetLCA {
    private static final String TYPE = "rwt.widgets.Grid";
    private static final String[] ALLOWED_STYLES = new String[]{"SINGLE", "MULTI", "CHECK", "FULL_SELECTION", "HIDE_SELECTION", "VIRTUAL", "NO_SCROLL", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_ITEM_COUNT = "itemCount";
    private static final String PROP_ITEM_HEIGHT = "itemHeight";
    private static final String PROP_ITEM_METRICS = "itemMetrics";
    private static final String PROP_COLUMN_COUNT = "columnCount";
    private static final String PROP_TREE_COLUMN = "treeColumn";
    private static final String PROP_FIXED_COLUMNS = "fixedColumns";
    private static final String PROP_HEADER_HEIGHT = "headerHeight";
    private static final String PROP_HEADER_VISIBLE = "headerVisible";
    private static final String PROP_LINES_VISIBLE = "linesVisible";
    private static final String PROP_TOP_ITEM_INDEX = "topItemIndex";
    private static final String PROP_FOCUS_ITEM = "focusItem";
    private static final String PROP_SCROLL_LEFT = "scrollLeft";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SORT_DIRECTION = "sortDirection";
    private static final String PROP_SORT_COLUMN = "sortColumn";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String PROP_SETDATA_LISTENER = "SetData";
    private static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final String PROP_ALWAYS_HIDE_SELECTION = "alwaysHideSelection";
    private static final String PROP_ENABLE_CELL_TOOLTIP = "enableCellToolTip";
    private static final String PROP_CELL_TOOLTIP_TEXT = "cellToolTipText";
    private static final String PROP_MARKUP_ENABLED = "markupEnabled";
    private static final int ZERO = 0;
    private static final String[] DEFAULT_SELECTION = new String[0];
    private static final String DEFAULT_SORT_DIRECTION = "none";

    public void preserveValues(Widget widget) {
        Table table = (Table)widget;
        ControlLCAUtil.preserveValues(table);
        WidgetLCAUtil.preserveCustomVariant(table);
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_COUNT, table.getItemCount());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_HEIGHT, table.getItemHeight());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ITEM_METRICS, TableLCA.getItemMetrics(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_COLUMN_COUNT, table.getColumnCount());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_FIXED_COLUMNS, this.getFixedColumns(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_HEADER_HEIGHT, table.getHeaderHeight());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_HEADER_VISIBLE, table.getHeaderVisible());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_LINES_VISIBLE, table.getLinesVisible());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_TOP_ITEM_INDEX, table.getTopIndex());
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_FOCUS_ITEM, TableLCA.getFocusItem(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SCROLL_LEFT, TableLCA.getScrollLeft(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SELECTION, TableLCA.getSelection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SORT_DIRECTION, TableLCA.getSortDirection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_SORT_COLUMN, table.getSortColumn());
        WidgetLCAUtil.preserveListener(table, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(table, 13));
        WidgetLCAUtil.preserveListener(table, PROP_SETDATA_LISTENER, this.listensToSetData(table));
        WidgetLCAUtil.preserveListener(table, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(table, 14));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ALWAYS_HIDE_SELECTION, TableLCA.hasAlwaysHideSelection(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(table));
        WidgetLCAUtil.preserveProperty((Widget)table, PROP_CELL_TOOLTIP_TEXT, null);
        ScrollBarLCAUtil.preserveValues(table);
    }

    public void readData(Widget widget) {
        Table table = (Table)widget;
        TableLCA.readTopItemIndex(table);
        TableLCA.readScrollLeft(table);
        TableLCA.readSelection(table);
        TableLCA.readFocusIndex(table);
        TableLCA.readWidgetSelected(table);
        TableLCA.readWidgetDefaultSelected(table);
        TableLCA.readCellToolTipTextRequested(table);
        ControlLCAUtil.processEvents(table);
        ControlLCAUtil.processKeyEvents(table);
        ControlLCAUtil.processMenuDetect(table);
        ScrollBarLCAUtil.processSelectionEvent(table);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Table table = (Table)widget;
        IClientObject clientObject = ClientObjectFactory.getClientObject(table);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(table.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(table, ALLOWED_STYLES)));
        clientObject.set("appearance", "table");
        ITableAdapter adapter = TableLCA.getTableAdapter(table);
        if ((table.getStyle() & 0x20) != 0) {
            JsonArray metrics = new JsonArray().add(adapter.getCheckLeft()).add(adapter.getCheckWidth());
            clientObject.set("checkBoxMetrics", metrics);
        }
        if (this.getFixedColumns(table) >= 0) {
            clientObject.set("splitContainer", true);
        }
        clientObject.set("indentionWidth", 0);
        clientObject.set(PROP_TREE_COLUMN, -1);
        clientObject.set(PROP_MARKUP_ENABLED, TableLCA.isMarkupEnabled(table));
        ScrollBarLCAUtil.renderInitialization(table);
    }

    public void renderChanges(Widget widget) throws IOException {
        Table table = (Table)widget;
        ControlLCAUtil.renderChanges(table);
        WidgetLCAUtil.renderCustomVariant(table);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ITEM_COUNT, table.getItemCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ITEM_HEIGHT, table.getItemHeight(), 0);
        TableLCA.renderItemMetrics(table);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_COLUMN_COUNT, table.getColumnCount(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_FIXED_COLUMNS, this.getFixedColumns(table), -1);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_HEADER_HEIGHT, table.getHeaderHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_HEADER_VISIBLE, table.getHeaderVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_LINES_VISIBLE, table.getLinesVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_TOP_ITEM_INDEX, table.getTopIndex(), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_FOCUS_ITEM, TableLCA.getFocusItem(table), null);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SCROLL_LEFT, TableLCA.getScrollLeft(table), 0);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SELECTION, TableLCA.getSelection(table), DEFAULT_SELECTION);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SORT_DIRECTION, TableLCA.getSortDirection(table), DEFAULT_SORT_DIRECTION);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_SORT_COLUMN, table.getSortColumn(), null);
        WidgetLCAUtil.renderListener(table, PROP_SELECTION_LISTENER, EventLCAUtil.isListening(table, 13), false);
        WidgetLCAUtil.renderListener(table, PROP_SETDATA_LISTENER, this.listensToSetData(table), false);
        WidgetLCAUtil.renderListener(table, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(table, 14), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ALWAYS_HIDE_SELECTION, TableLCA.hasAlwaysHideSelection(table), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_ENABLE_CELL_TOOLTIP, CellToolTipUtil.isEnabledFor(table), false);
        WidgetLCAUtil.renderProperty((Widget)table, PROP_CELL_TOOLTIP_TEXT, TableLCA.getCellToolTipText(table), null);
        ScrollBarLCAUtil.renderChanges(table);
    }

    public void doRedrawFake(Control control) {
        Table table = (Table)control;
        TableLCA.getTableAdapter(table).checkData();
    }

    private static void readSelection(Table table) {
        String[] values = ProtocolUtil.readPropertyValueAsStringArray(WidgetUtil.getId(table), PROP_SELECTION);
        if (values != null) {
            int[] newSelection = new int[values.length];
            int i = 0;
            while (i < values.length) {
                String itemId = values[i];
                TableItem item = TableLCA.getItem(table, itemId);
                newSelection[i] = item != null ? table.indexOf(item) : -1;
                ++i;
            }
            table.deselectAll();
            table.select(newSelection);
        }
    }

    private static void readTopItemIndex(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_TOP_ITEM_INDEX);
        if (value != null) {
            int topIndex = NumberFormatUtil.parseInt(value);
            table.setTopIndex(topIndex);
        }
    }

    private static void readFocusIndex(Table table) {
        TableItem item;
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_FOCUS_ITEM);
        if (value != null && (item = TableLCA.getItem(table, value)) != null) {
            TableLCA.getTableAdapter(table).setFocusIndex(table.indexOf(item));
        }
    }

    private static void readScrollLeft(Table table) {
        String value = WidgetLCAUtil.readPropertyValue(table, PROP_SCROLL_LEFT);
        if (value != null) {
            int leftOffset = NumberFormatUtil.parseInt(value);
            table.getAdapter(ITableAdapter.class).setLeftOffset(leftOffset);
        }
    }

    private static void readWidgetSelected(Table table) {
        String value;
        TableItem item;
        String eventName = PROP_SELECTION_LISTENER;
        if (WidgetLCAUtil.wasEventSent(table, eventName) && (item = TableLCA.getItem(table, value = WidgetLCAUtil.readEventPropertyValue(table, eventName, "item"))) != null) {
            ControlLCAUtil.processSelection(table, item, false);
        }
    }

    private static void readWidgetDefaultSelected(Table table) {
        String eventName = PROP_DEFAULT_SELECTION_LISTENER;
        if (WidgetLCAUtil.wasEventSent(table, eventName)) {
            TableItem item = TableLCA.getFocusItem(table);
            String value = WidgetLCAUtil.readEventPropertyValue(table, eventName, "item");
            TableItem selectedItem = TableLCA.getItem(table, value);
            if (selectedItem != null) {
                item = selectedItem;
            }
            ControlLCAUtil.processDefaultSelection(table, item);
        }
    }

    private static void readCellToolTipTextRequested(Table table) {
        ICellToolTipAdapter adapter = CellToolTipUtil.getAdapter(table);
        adapter.setCellToolTipText(null);
        ICellToolTipProvider provider = adapter.getCellToolTipProvider();
        String methodName = "renderToolTipText";
        if (provider != null && ProtocolUtil.wasCallReceived(WidgetUtil.getId(table), methodName)) {
            String itemId = ProtocolUtil.readCallPropertyValueAsString(WidgetUtil.getId(table), methodName, "item");
            String column = ProtocolUtil.readCallPropertyValueAsString(WidgetUtil.getId(table), methodName, "column");
            int columnIndex = NumberFormatUtil.parseInt(column);
            TableItem item = TableLCA.getItem(table, itemId);
            if (item != null && (columnIndex == 0 || columnIndex < table.getColumnCount())) {
                provider.getToolTipText(item, columnIndex);
            }
        }
    }

    private static String getCellToolTipText(Table table) {
        return CellToolTipUtil.getAdapter(table).getCellToolTipText();
    }

    private boolean listensToSetData(Table table) {
        return (table.getStyle() & 0x10000000) != 0;
    }

    private static boolean isMarkupEnabled(Table table) {
        return Boolean.TRUE.equals(table.getData("org.eclipse.rap.rwt.markupEnabled"));
    }

    private static String[] getSelection(Table table) {
        TableItem[] selection = table.getSelection();
        String[] result = new String[selection.length];
        int i = 0;
        while (i < result.length) {
            result[i] = WidgetUtil.getId(selection[i]);
            ++i;
        }
        return result;
    }

    private int getFixedColumns(Table table) {
        return TableLCA.getTableAdapter(table).getFixedColumns();
    }

    private static int getScrollLeft(Table table) {
        return TableLCA.getTableAdapter(table).getLeftOffset();
    }

    private static TableItem getFocusItem(Table table) {
        TableItem result = null;
        int focusIndex = TableLCA.getTableAdapter(table).getFocusIndex();
        if (focusIndex != -1) {
            result = table.getItem(focusIndex);
        }
        return result;
    }

    private static String getSortDirection(Table table) {
        String result = DEFAULT_SORT_DIRECTION;
        if (table.getSortDirection() == 128) {
            result = "up";
        } else if (table.getSortDirection() == 1024) {
            result = "down";
        }
        return result;
    }

    static boolean hasAlwaysHideSelection(Table table) {
        Object data = table.getData(Table.ALWAYS_HIDE_SELECTION);
        return Boolean.TRUE.equals(data);
    }

    private static TableItem getItem(Table table, String itemId) {
        TableItem item;
        String[] idParts = itemId.split("#");
        if (idParts.length == 2) {
            int index = Integer.parseInt(idParts[1]);
            item = table.getItem(index);
        } else {
            item = (TableItem)WidgetUtil.find(table, itemId);
        }
        return item;
    }

    private static ITableAdapter getTableAdapter(Table table) {
        return table.getAdapter(ITableAdapter.class);
    }

    private static void renderItemMetrics(Table table) {
        ItemMetrics[] itemMetrics = TableLCA.getItemMetrics(table);
        if (WidgetLCAUtil.hasChanged(table, PROP_ITEM_METRICS, itemMetrics)) {
            JsonArray metrics = new JsonArray();
            int i = 0;
            while (i < itemMetrics.length) {
                metrics.add(new JsonArray().add(i).add(itemMetrics[i].left).add(itemMetrics[i].width).add(itemMetrics[i].imageLeft).add(itemMetrics[i].imageWidth).add(itemMetrics[i].textLeft).add(itemMetrics[i].textWidth));
                ++i;
            }
            ClientObjectFactory.getClientObject(table).set(PROP_ITEM_METRICS, metrics);
        }
    }

    static ItemMetrics[] getItemMetrics(Table table) {
        ItemMetrics[] result;
        block6: {
            ITableAdapter tableAdapter;
            int columnCount;
            block5: {
                columnCount = Math.max(1, table.getColumnCount());
                result = new ItemMetrics[columnCount];
                int i = 0;
                while (i < columnCount) {
                    result[i] = new ItemMetrics();
                    ++i;
                }
                tableAdapter = TableLCA.getTableAdapter(table);
                TableItem measureItem = tableAdapter.getMeasureItem();
                if (measureItem == null) break block5;
                int i2 = 0;
                while (i2 < columnCount) {
                    int leftOffset = tableAdapter.getColumnLeftOffset(i2);
                    Rectangle bounds = measureItem.getBounds(i2);
                    Rectangle imageBounds = measureItem.getImageBounds(i2);
                    Rectangle textBounds = measureItem.getTextBounds(i2);
                    int imageWidth = tableAdapter.getItemImageWidth(i2);
                    if (table.getColumnCount() > 0) {
                        TableColumn column = table.getColumn(i2);
                        int columnLeft = tableAdapter.getColumnLeft(column);
                        int columnWidth = column.getWidth();
                        int maxImageWidth = columnWidth - (imageBounds.x - columnLeft + leftOffset);
                        if (imageWidth > maxImageWidth) {
                            imageWidth = Math.max(0, maxImageWidth);
                        }
                    }
                    result[i2].left = bounds.x + leftOffset;
                    result[i2].width = bounds.width;
                    result[i2].imageLeft = imageBounds.x + leftOffset;
                    result[i2].imageWidth = imageWidth;
                    result[i2].textLeft = textBounds.x + leftOffset;
                    result[i2].textWidth = textBounds.width;
                    ++i2;
                }
                break block6;
            }
            if (table.getColumnCount() <= 0) break block6;
            int i = 0;
            while (i < columnCount) {
                TableColumn column = table.getColumn(i);
                int columnLeft = tableAdapter.getColumnLeft(column);
                int columnWidth = column.getWidth();
                result[i].left = columnLeft;
                result[i].width = columnWidth;
                ++i;
            }
        }
        return result;
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

