/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.client.service.BrowserNavigation;
import org.eclipse.rap.rwt.client.service.BrowserNavigationEvent;
import org.eclipse.rap.rwt.client.service.BrowserNavigationListener;
import org.eclipse.rap.rwt.client.service.ClientInfo;
import org.eclipse.rap.rwt.client.service.ExitConfirmation;
import org.eclipse.rap.rwt.client.service.JavaScriptExecutor;
import org.eclipse.rap.rwt.client.service.JavaScriptLoader;
import org.eclipse.rap.rwt.client.service.UrlLauncher;
import org.eclipse.rap.rwt.service.ResourceManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ClientServicesTab
extends ExampleTab {
    private static final String MINI_PDF = "clientservices/mini.pdf";
    private static final String MINI_JS = "clientservices/mini.js";
    private BrowserNavigationListener navigationListener = new BrowserNavigationListener(){

        public void navigated(BrowserNavigationEvent event) {
            ClientServicesTab.this.log("Navigated to " + event.getState());
        }
    };

    public ClientServicesTab() {
        super("Client Services");
    }

    protected void createStyleControls(Composite parent) {
    }

    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.registerResources();
        this.createClientInfoExample(parent);
        this.createBrowserNavigationExample(parent);
        this.createExitConfirmationExample(parent);
        this.createUrlLauncherExample(parent);
        this.createJavaScriptLoaderExample(parent);
        this.createJavaScriptExecuterExample(parent);
    }

    private void registerResources() {
        this.register(MINI_PDF, "resources/mini.pdf");
        this.register(MINI_JS, "resources/mini.js");
    }

    private void register(String url, String filepath) {
        ResourceManager manager = RWT.getResourceManager();
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!manager.isRegistered(url)) {
            InputStream stream = classLoader.getResourceAsStream(filepath);
            manager.register(url, stream);
            try {
                stream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException();
            }
        }
    }

    private void createClientInfoExample(Composite parent) {
        Group group = this.createGroup(parent, "ClientInfo", 2);
        ClientInfo info = (ClientInfo)RWT.getClient().getService(ClientInfo.class);
        this.createLabel((Composite)group, "Locale: " + info.getLocale());
        this.createLabel((Composite)group, "Timezone Offset: " + info.getTimezoneOffset());
    }

    private void createBrowserNavigationExample(Composite parent) {
        Group group = this.createGroup(parent, "BrowserNavigation", 3);
        this.createLabel((Composite)group, "Id:");
        this.createLabel((Composite)group, "Title:");
        final Button listen = new Button((Composite)group, 32);
        listen.setText("Listener");
        final Text id = new Text((Composite)group, 2048);
        id.setText("foo1");
        id.setLayoutData((Object)new GridData(4, 4, true, false));
        final Text title = new Text((Composite)group, 2048);
        title.setText("Title of foo1");
        title.setLayoutData((Object)new GridData(4, 4, true, false));
        Button add = new Button((Composite)group, 8);
        add.setText("Add to History");
        add.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BrowserNavigation navigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
                navigation.pushState(id.getText(), title.getText());
            }
        });
        listen.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                BrowserNavigation navigation = (BrowserNavigation)RWT.getClient().getService(BrowserNavigation.class);
                if (listen.getSelection()) {
                    navigation.addBrowserNavigationListener(ClientServicesTab.this.navigationListener);
                } else {
                    navigation.removeBrowserNavigationListener(ClientServicesTab.this.navigationListener);
                }
            }
        });
    }

    private void createUrlLauncherExample(Composite parent) {
        Group group = this.createGroup(parent, "UrlLauncher", 2);
        final Combo url = new Combo((Composite)group, 0);
        url.add("http://www.eclipse.org/");
        url.add(RWT.getResourceManager().getLocation(MINI_PDF));
        url.add(RWT.getResourceManager().getLocation(MINI_JS));
        url.add("mailto:someone@nowhere.org");
        url.add("mailto:otherone@nowhere.org?cc=third@nowhere.org&subject=Did%20you%20know%3F&body=RAP%20is%20awesome!");
        url.add("skype:echo123");
        url.add("tel:555-123456");
        url.select(0);
        GridData layoutData = new GridData(4, 4, true, false);
        url.setLayoutData((Object)layoutData);
        Button launch = new Button((Composite)group, 8);
        launch.setLayoutData((Object)new GridData(16384, 4, false, false));
        launch.setText("Launch");
        Listener executeListener = new Listener(){

            public void handleEvent(Event event) {
                UrlLauncher launcher = (UrlLauncher)RWT.getClient().getService(UrlLauncher.class);
                launcher.openURL(url.getText());
            }
        };
        url.addListener(14, executeListener);
        launch.addListener(13, executeListener);
    }

    private void createExitConfirmationExample(Composite parent) {
        Group group = this.createGroup(parent, "ExitConfirmation", 2);
        final Text text = new Text((Composite)group, 2048);
        text.setText("Do you really want to exit?");
        GridData layoutData = new GridData(4, 4, true, false);
        text.setLayoutData((Object)layoutData);
        Button require = new Button((Composite)group, 8);
        require.setLayoutData((Object)new GridData(16384, 4, false, false));
        require.setText("Set");
        Listener executeListener = new Listener(){

            public void handleEvent(Event event) {
                ExitConfirmation conf = (ExitConfirmation)RWT.getClient().getService(ExitConfirmation.class);
                conf.setMessage(text.getText());
            }
        };
        text.addListener(14, executeListener);
        require.addListener(13, executeListener);
    }

    private void createJavaScriptLoaderExample(Composite parent) {
        Group group = this.createGroup(parent, "JavaScriptLoader", 2);
        final Text url = new Text((Composite)group, 2048);
        url.setText(RWT.getResourceManager().getLocation(MINI_JS));
        GridData layoutData = new GridData(4, 4, true, false);
        url.setLayoutData((Object)layoutData);
        Button require = new Button((Composite)group, 8);
        require.setLayoutData((Object)new GridData(16384, 4, false, false));
        require.setText("Require");
        Listener executeListener = new Listener(){

            public void handleEvent(Event event) {
                JavaScriptLoader loader = (JavaScriptLoader)RWT.getClient().getService(JavaScriptLoader.class);
                loader.require(url.getText());
            }
        };
        url.addListener(14, executeListener);
        require.addListener(13, executeListener);
    }

    private void createJavaScriptExecuterExample(Composite parent) {
        Group group = this.createGroup(parent, "JavaScriptExecuter", 2);
        final Combo script = new Combo((Composite)group, 0);
        script.add("alert( \"foo\" );");
        script.add("document.title = \"bar\";");
        script.add("window.location = \"http://www.eclipse.org/\";");
        script.add("alert( typeof globalData === \"undefined\" ? null : globalData );");
        script.select(0);
        GridData layoutData = new GridData(4, 4, true, false);
        script.setLayoutData((Object)layoutData);
        Button execute = new Button((Composite)group, 8);
        execute.setLayoutData((Object)new GridData(16384, 4, false, false));
        execute.setText("Execute");
        Listener executeListener = new Listener(){

            public void handleEvent(Event event) {
                JavaScriptExecutor executor = (JavaScriptExecutor)RWT.getClient().getService(JavaScriptExecutor.class);
                executor.execute(script.getText());
            }
        };
        script.addListener(14, executeListener);
        execute.addListener(13, executeListener);
    }

    private Group createGroup(Composite parent, String title, int cols) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)new GridLayout(cols, false));
        group.setText(title);
        return group;
    }

    private void createLabel(Composite parent, String text) {
        Label locale = new Label(parent, 0);
        locale.setLayoutData((Object)new GridData(16384, 4, true, false));
        locale.setText(text);
    }
}

