/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.rwt.internal.protocol.ClientObjectFactory;
import org.eclipse.rap.rwt.internal.protocol.IClientObject;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rap.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.lifecycle.WidgetAdapter;
import org.eclipse.rap.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class TextLCAUtil {
    private static final String TYPE = "rwt.widgets.Text";
    private static final String[] ALLOWED_STYLES = new String[]{"CENTER", "LEFT", "RIGHT", "MULTI", "SINGLE", "PASSWORD", "SEARCH", "WRAP", "H_SCROLL", "V_SCROLL", "BORDER"};
    private static final String[] ALLOWED_STYLES_WITH_SEARCH = new String[]{"CENTER", "LEFT", "RIGHT", "SINGLE", "SEARCH", "ICON_CANCEL", "ICON_SEARCH", "BORDER"};
    static final String PROP_TEXT = "text";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_SELECTION = "selection";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_ECHO_CHAR = "echoChar";
    static final String PROP_MESSAGE = "message";
    static final String PROP_MODIFY_LISTENER = "Modify";
    static final String PROP_DEFAULT_SELECTION_LISTENER = "DefaultSelection";
    private static final Point ZERO_SELECTION = new Point(0, 0);

    private TextLCAUtil() {
    }

    static void preserveValues(Text text) {
        ControlLCAUtil.preserveValues(text);
        WidgetLCAUtil.preserveCustomVariant(text);
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT, text.getText());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_SELECTION, text.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_TEXT_LIMIT, TextLCAUtil.getTextLimit(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_EDITABLE, text.getEditable());
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_ECHO_CHAR, TextLCAUtil.getEchoChar(text));
        WidgetLCAUtil.preserveProperty((Widget)text, PROP_MESSAGE, text.getMessage());
        WidgetLCAUtil.preserveListener(text, PROP_MODIFY_LISTENER, TextLCAUtil.hasModifyListener(text));
        WidgetLCAUtil.preserveListener(text, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(text, 14));
    }

    static void renderInitialization(Text text) {
        IClientObject clientObject = ClientObjectFactory.getClientObject(text);
        clientObject.create(TYPE);
        clientObject.set("parent", WidgetUtil.getId(text.getParent()));
        clientObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(text, TextLCAUtil.getAllowedStyles(text))));
    }

    static void renderChanges(Text text) {
        ControlLCAUtil.renderChanges(text);
        WidgetLCAUtil.renderCustomVariant(text);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT, text.getText(), "");
        WidgetLCAUtil.renderProperty((Widget)text, PROP_EDITABLE, text.getEditable(), true);
        TextLCAUtil.renderSelection(text);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_TEXT_LIMIT, TextLCAUtil.getTextLimit(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_ECHO_CHAR, TextLCAUtil.getEchoChar(text), null);
        WidgetLCAUtil.renderProperty((Widget)text, PROP_MESSAGE, text.getMessage(), "");
        WidgetLCAUtil.renderListener(text, PROP_MODIFY_LISTENER, TextLCAUtil.hasModifyListener(text), false);
        WidgetLCAUtil.renderListener(text, PROP_DEFAULT_SELECTION_LISTENER, EventLCAUtil.isListening(text, 14), false);
    }

    static void readTextAndSelection(final Text text) {
        final Point selection = TextLCAUtil.readSelection(text);
        final String txt = WidgetLCAUtil.readPropertyValue(text, PROP_TEXT);
        if (txt != null) {
            if (EventLCAUtil.isListening(text, 25)) {
                ProcessActionRunner.add(new Runnable(){

                    public void run() {
                        WidgetAdapter adapter = WidgetUtil.getAdapter(text);
                        TextLCAUtil.getTextAdapter(text).setText(txt);
                        adapter.preserve(TextLCAUtil.PROP_TEXT, txt);
                        if (selection != null) {
                            text.setSelection(selection);
                            adapter.preserve(TextLCAUtil.PROP_SELECTION, text.getSelection());
                        }
                    }
                });
            } else {
                TextLCAUtil.getTextAdapter(text).setText(txt);
                if (selection != null) {
                    text.setSelection(selection);
                }
            }
        } else if (selection != null) {
            text.setSelection(selection);
        }
    }

    private static Point readSelection(Text text) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue(text, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue(text, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = NumberFormatUtil.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + NumberFormatUtil.parseInt(selLength);
            }
        }
        return result;
    }

    private static void renderSelection(Text text) {
        Point newValue = text.getSelection();
        boolean changed = WidgetLCAUtil.hasChanged(text, PROP_SELECTION, newValue, ZERO_SELECTION);
        if (!changed) {
            boolean bl = changed = WidgetLCAUtil.hasChanged(text, PROP_TEXT, text.getText()) && !newValue.equals(ZERO_SELECTION);
        }
        if (changed) {
            IClientObject clientObject = ClientObjectFactory.getClientObject(text);
            clientObject.set(PROP_SELECTION, new JsonArray().add(newValue.x).add(newValue.y));
        }
    }

    private static String[] getAllowedStyles(Text text) {
        return (text.getStyle() & 0x80) != 0 ? ALLOWED_STYLES_WITH_SEARCH : ALLOWED_STYLES;
    }

    private static Integer getTextLimit(Text text) {
        Integer result = null;
        int textLimit = text.getTextLimit();
        if (textLimit > 0 && textLimit != Integer.MAX_VALUE) {
            result = new Integer(textLimit);
        }
        return result;
    }

    private static String getEchoChar(Text text) {
        return text.getEchoChar() == '\u0000' ? null : String.valueOf(text.getEchoChar());
    }

    private static boolean hasModifyListener(Text text) {
        return EventLCAUtil.isListening(text, 24) || EventLCAUtil.isListening(text, 25);
    }

    private static ITextAdapter getTextAdapter(Text text) {
        return text.getAdapter(ITextAdapter.class);
    }
}

