/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationAdminImpl;
import org.eclipse.equinox.internal.cm.ConfigurationDictionary;
import org.eclipse.equinox.internal.cm.ConfigurationStore;
import org.osgi.framework.Bundle;
import org.osgi.service.cm.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationImpl
implements Configuration {
    static final String LOCATION_BOUND = "org.eclipse.equinox.cm.location.bound";
    static final String PROPERTIES_NULL = "org.eclipse.equinox.cm.properties.null";
    static final String CHANGE_COUNT = "org.eclipse.equinox.cm.change.count";
    private final ConfigurationAdminFactory configurationAdminFactory;
    private final ConfigurationStore configurationStore;
    private String bundleLocation;
    private final String factoryPid;
    private final String pid;
    private ConfigurationDictionary dictionary;
    private boolean deleted = false;
    private boolean bound = false;
    private long changeCount;
    private Object storageToken;
    private final ReentrantLock lock = new ReentrantLock();

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, String factoryPid, String pid, String bundleLocation, boolean bind) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.factoryPid = factoryPid;
        this.pid = pid;
        this.bundleLocation = bundleLocation;
        this.changeCount = 0L;
        this.bound = bind;
    }

    public ConfigurationImpl(ConfigurationAdminFactory configurationAdminFactory, ConfigurationStore configurationStore, Dictionary<String, ?> dictionary, Object storageToken) {
        this.configurationAdminFactory = configurationAdminFactory;
        this.configurationStore = configurationStore;
        this.pid = (String)dictionary.get("service.pid");
        this.factoryPid = (String)dictionary.get("service.factoryPid");
        this.bundleLocation = (String)dictionary.get("service.bundleLocation");
        Boolean boundProp = (Boolean)dictionary.remove(LOCATION_BOUND);
        this.bound = boundProp == null ? false : boundProp;
        Long changeCountProp = (Long)dictionary.remove(CHANGE_COUNT);
        this.changeCount = changeCountProp == null ? 0L : changeCountProp;
        Boolean nullProps = (Boolean)dictionary.remove(PROPERTIES_NULL);
        if (nullProps == null || !nullProps.booleanValue()) {
            this.updateDictionary(dictionary);
        }
        this.storageToken = storageToken;
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    void checkLocked() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Thread not lock owner");
        }
    }

    boolean bind(String callerLocation) {
        try {
            this.lock();
            if (this.bundleLocation == null) {
                this.bundleLocation = callerLocation;
                this.bound = true;
                try {
                    this.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
            }
            boolean bl = callerLocation.equals(this.bundleLocation);
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    boolean isBound() {
        try {
            this.lock();
            boolean bl = this.bound;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    void unbind(Bundle bundle) {
        block5: {
            try {
                this.lock();
                String callerLocation = ConfigurationAdminImpl.getLocation(bundle);
                if (!this.bound || !callerLocation.equals(this.bundleLocation)) break block5;
                this.bundleLocation = null;
                this.bound = false;
                try {
                    this.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.configurationAdminFactory.notifyLocationChanged(this, callerLocation, this.factoryPid != null);
                this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
            }
            finally {
                this.unlock();
            }
        }
    }

    public void delete() {
        Object deleteToken;
        try {
            this.lock();
            this.checkDeleted();
            this.deleted = true;
            this.configurationAdminFactory.notifyConfigurationDeleted(this, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(2, this.factoryPid, this.pid);
            deleteToken = this.storageToken;
            this.storageToken = null;
        }
        finally {
            this.unlock();
        }
        this.configurationStore.removeConfiguration(this.pid, deleteToken);
    }

    private void checkDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("deleted");
        }
    }

    String getLocation() {
        try {
            this.lock();
            String string = this.bundleLocation;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getBundleLocation() {
        try {
            this.lock();
            this.checkDeleted();
            this.configurationAdminFactory.checkConfigurePermission(this.bundleLocation, null);
            if (this.bundleLocation != null) {
                String string = this.bundleLocation;
                return string;
            }
            return null;
        }
        finally {
            this.unlock();
        }
    }

    String getFactoryPid(boolean checkDeleted) {
        try {
            this.lock();
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.factoryPid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getFactoryPid() {
        return this.getFactoryPid(true);
    }

    String getPid(boolean checkDeleted) {
        try {
            this.lock();
            if (checkDeleted) {
                this.checkDeleted();
            }
            String string = this.pid;
            return string;
        }
        finally {
            this.unlock();
        }
    }

    public String getPid() {
        return this.getPid(true);
    }

    public Dictionary<String, Object> getProperties() {
        try {
            this.lock();
            this.checkDeleted();
            if (this.dictionary == null) {
                return null;
            }
            ConfigurationDictionary copy = this.dictionary.copy();
            ConfigurationImpl.fileAutoProperties(copy, this, false, false);
            ConfigurationDictionary configurationDictionary = copy;
            return configurationDictionary;
        }
        finally {
            this.unlock();
        }
    }

    Dictionary<String, Object> getAllProperties(boolean includeStorageKeys) {
        try {
            this.lock();
            if (this.deleted) {
                return null;
            }
            ConfigurationDictionary copy = this.getProperties();
            if (copy == null) {
                if (!includeStorageKeys) {
                    return null;
                }
                copy = new ConfigurationDictionary();
            }
            ConfigurationImpl.fileAutoProperties(copy, this, true, includeStorageKeys);
            ConfigurationDictionary configurationDictionary = copy;
            return configurationDictionary;
        }
        finally {
            this.unlock();
        }
    }

    private static void fileAutoProperties(Dictionary<String, Object> dictionary, ConfigurationImpl config, boolean includeLoc, boolean includeStorageKey) {
        String loc;
        dictionary.put("service.pid", config.getPid(false));
        String factoryPid = config.getFactoryPid(false);
        if (factoryPid != null) {
            dictionary.put("service.factoryPid", factoryPid);
        }
        if (includeLoc && (loc = config.getLocation()) != null) {
            dictionary.put("service.bundleLocation", loc);
        }
        if (includeStorageKey) {
            if (config.dictionary == null) {
                dictionary.put(PROPERTIES_NULL, Boolean.TRUE);
            }
            dictionary.put(CHANGE_COUNT, config.getChangeCount());
            if (config.isBound()) {
                dictionary.put(LOCATION_BOUND, Boolean.TRUE);
            }
        }
    }

    public void setBundleLocation(String bundleLocation) {
        try {
            this.lock();
            this.checkDeleted();
            this.configurationAdminFactory.checkConfigurePermission(this.bundleLocation, null);
            this.configurationAdminFactory.checkConfigurePermission(bundleLocation, null);
            String oldLocation = this.bundleLocation;
            this.bundleLocation = bundleLocation;
            this.bound = false;
            try {
                this.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.configurationAdminFactory.notifyLocationChanged(this, oldLocation, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(3, this.factoryPid, this.pid);
        }
        finally {
            this.unlock();
        }
    }

    public void update() throws IOException {
        try {
            this.lock();
            this.checkDeleted();
            if (this.dictionary == null) {
                this.dictionary = new ConfigurationDictionary();
            }
            ++this.changeCount;
            this.save();
            this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
        }
        finally {
            this.unlock();
        }
    }

    public void update(Dictionary<String, ?> properties) throws IOException {
        try {
            this.lock();
            this.checkDeleted();
            this.updateDictionary(properties);
            ++this.changeCount;
            this.save();
            this.configurationAdminFactory.notifyConfigurationUpdated(this, this.factoryPid != null);
            this.configurationAdminFactory.dispatchEvent(1, this.factoryPid, this.pid);
        }
        finally {
            this.unlock();
        }
    }

    private void save() throws IOException {
        this.checkLocked();
        this.storageToken = this.configurationStore.saveConfiguration(this.pid, this, this.storageToken);
    }

    private void updateDictionary(Dictionary<String, ?> properties) {
        ConfigurationDictionary newDictionary = new ConfigurationDictionary();
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (newDictionary.get(key) == null) {
                Object value = properties.get(key);
                if (value.getClass().isArray()) {
                    int arrayLength = Array.getLength(value);
                    Object copyOfArray = Array.newInstance(value.getClass().getComponentType(), arrayLength);
                    System.arraycopy(value, 0, copyOfArray, 0, arrayLength);
                    newDictionary.put(key, copyOfArray);
                    continue;
                }
                if (value instanceof Collection) {
                    newDictionary.put(key, (Object)new Vector((Collection)value));
                    continue;
                }
                newDictionary.put(key, properties.get(key));
                continue;
            }
            throw new IllegalArgumentException(String.valueOf(key) + " is already present or is a case variant.");
        }
        newDictionary.remove("service.pid");
        newDictionary.remove("service.factoryPid");
        newDictionary.remove("service.bundleLocation");
        this.dictionary = newDictionary;
    }

    public boolean equals(Object obj) {
        return obj instanceof ConfigurationImpl && this.pid.equals(((ConfigurationImpl)obj).getPid());
    }

    public int hashCode() {
        return this.pid.hashCode();
    }

    boolean isDeleted() {
        try {
            this.lock();
            boolean bl = this.deleted;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    public long getChangeCount() {
        try {
            this.lock();
            this.checkDeleted();
            long l = this.changeCount;
            return l;
        }
        finally {
            this.unlock();
        }
    }
}

