/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.ctabfolderkit;

import java.io.IOException;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ControlLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCA;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetLCAUtil;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.protocol.RemoteObjectFactory;
import org.eclipse.rap.rwt.remote.JsonMapping;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.ICTabFolderAdapter;
import org.eclipse.swt.internal.custom.ctabfolderkit.CTabFolderOperationHandler;
import org.eclipse.swt.internal.widgets.IWidgetGraphicsAdapter;
import org.eclipse.swt.widgets.Widget;

public final class CTabFolderLCA
extends WidgetLCA<CTabFolder> {
    public static final CTabFolderLCA INSTANCE = new CTabFolderLCA();
    private static final String TYPE = "rwt.widgets.CTabFolder";
    private static final String[] ALLOWED_STYLES = new String[]{"CLOSE", "FLAT", "SINGLE", "MULTI", "NO_RADIO_GROUP", "BORDER"};
    private static final String PROP_TOOLTIP_TEXTS = "toolTipTexts";
    private static final String PROP_TAB_POSITION = "tabPosition";
    private static final String PROP_TAB_HEIGHT = "tabHeight";
    private static final String PROP_MIN_MAX_STATE = "minMaxState";
    private static final String PROP_MINIMIZE_BOUNDS = "minimizeBounds";
    private static final String PROP_MINIMIZE_VISIBLE = "minimizeVisible";
    private static final String PROP_MAXIMIZE_BOUNDS = "maximizeBounds";
    private static final String PROP_MAXIMIZE_VISIBLE = "maximizeVisible";
    private static final String PROP_CHEVRON_BOUNDS = "chevronBounds";
    private static final String PROP_CHEVRON_VISIBLE = "chevronVisible";
    private static final String PROP_UNSELECTED_CLOSE_VISIBLE = "unselectedCloseVisible";
    private static final String PROP_SELECTION = "selection";
    private static final String PROP_SELECTION_BACKGROUND = "selectionBackground";
    private static final String PROP_SELECTION_FOREGROUND = "selectionForeground";
    private static final String PROP_SELECTION_BACKGROUND_IMAGE = "selectionBackgroundImage";
    private static final String PROP_SELECTION_BG_GRADIENT = "selectionBackgroundGradient";
    private static final String PROP_SELECTION_BG_GRADIENT_COLORS = "selectionBgGradientColors";
    private static final String PROP_SELECTION_BG_GRADIENT_PERCENTS = "selectionBgGradientPercents";
    private static final String PROP_SELECTION_BG_GRADIENT_VERTICAL = "selectionBgGradientVertical";
    private static final String PROP_BORDER_VISIBLE = "borderVisible";
    private static final String PROP_FOLDER_LISTENER = "Folder";
    private static final String PROP_SELECTION_LISTENER = "Selection";
    private static final String DEFAULT_TAB_POSITION = "top";
    private static final int DEFAULT_TAB_HEIGHT = 0;
    private static final String DEFAULT_MIN_MAX_STATE = "normal";
    private static final Rectangle ZERO_BOUNDS = new Rectangle(0, 0, 0, 0);

    @Override
    public void preserveValues(CTabFolder folder) {
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_TAB_POSITION, CTabFolderLCA.getTabPosition(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_TAB_HEIGHT, folder.getTabHeight());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MIN_MAX_STATE, CTabFolderLCA.getMinMaxState(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MINIMIZE_BOUNDS, CTabFolderLCA.getMinimizeBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MINIMIZE_VISIBLE, folder.getMinimizeVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MAXIMIZE_BOUNDS, CTabFolderLCA.getMaximizeBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_MAXIMIZE_VISIBLE, folder.getMaximizeVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_CHEVRON_BOUNDS, CTabFolderLCA.getChevronBounds(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_CHEVRON_VISIBLE, CTabFolderLCA.getChevronVisible(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_UNSELECTED_CLOSE_VISIBLE, folder.getUnselectedCloseVisible());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION, folder.getSelection());
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BACKGROUND, CTabFolderLCA.getSelectionBackground(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_FOREGROUND, CTabFolderLCA.getSelectionForeground(folder));
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BACKGROUND_IMAGE, CTabFolderLCA.getSelectionBackgroundImage(folder));
        CTabFolderLCA.preserveSelectionBgGradient(folder);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_BORDER_VISIBLE, folder.getBorderVisible());
    }

    @Override
    public void renderInitialization(CTabFolder folder) throws IOException {
        RemoteObject remoteObject = RemoteObjectFactory.createRemoteObject(folder, TYPE);
        remoteObject.setHandler(new CTabFolderOperationHandler(folder));
        remoteObject.set("parent", WidgetUtil.getId(folder.getParent()));
        remoteObject.set("style", JsonUtil.createJsonArray(WidgetLCAUtil.getStyles(folder, ALLOWED_STYLES)));
        JsonArray toolTipTexts = new JsonArray().add(SWT.getMessage("SWT_Minimize")).add(SWT.getMessage("SWT_Maximize")).add(SWT.getMessage("SWT_Restore")).add(SWT.getMessage("SWT_ShowList")).add(SWT.getMessage("SWT_Close"));
        remoteObject.set(PROP_TOOLTIP_TEXTS, toolTipTexts);
        remoteObject.listen(PROP_SELECTION_LISTENER, true);
        remoteObject.listen(PROP_FOLDER_LISTENER, true);
    }

    @Override
    public void renderChanges(CTabFolder folder) throws IOException {
        ControlLCAUtil.renderChanges(folder);
        WidgetLCAUtil.renderCustomVariant(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_TAB_POSITION, CTabFolderLCA.getTabPosition(folder), DEFAULT_TAB_POSITION);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_TAB_HEIGHT, folder.getTabHeight(), 0);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MIN_MAX_STATE, CTabFolderLCA.getMinMaxState(folder), DEFAULT_MIN_MAX_STATE);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MINIMIZE_BOUNDS, CTabFolderLCA.getMinimizeBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MINIMIZE_VISIBLE, folder.getMinimizeVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MAXIMIZE_BOUNDS, CTabFolderLCA.getMaximizeBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_MAXIMIZE_VISIBLE, folder.getMaximizeVisible(), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_CHEVRON_BOUNDS, CTabFolderLCA.getChevronBounds(folder), ZERO_BOUNDS);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_CHEVRON_VISIBLE, CTabFolderLCA.getChevronVisible(folder), false);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_UNSELECTED_CLOSE_VISIBLE, folder.getUnselectedCloseVisible(), true);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION, folder.getSelection(), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_BACKGROUND, CTabFolderLCA.getSelectionBackground(folder), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_FOREGROUND, CTabFolderLCA.getSelectionForeground(folder), null);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_SELECTION_BACKGROUND_IMAGE, CTabFolderLCA.getSelectionBackgroundImage(folder), null);
        CTabFolderLCA.renderSelectionBackgroundGradient(folder);
        WidgetLCAUtil.renderProperty((Widget)folder, PROP_BORDER_VISIBLE, folder.getBorderVisible(), false);
        WidgetLCAUtil.renderListenDefaultSelection(folder);
    }

    private static void preserveSelectionBgGradient(CTabFolder folder) {
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(folder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents);
        WidgetLCAUtil.preserveProperty((Widget)folder, PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical);
    }

    private static void renderSelectionBackgroundGradient(CTabFolder folder) {
        boolean hasChanged;
        ICTabFolderAdapter adapter = CTabFolderLCA.getCTabFolderAdapter(folder);
        IWidgetGraphicsAdapter gfxAdapter = adapter.getUserSelectionBackgroundGradient();
        Color[] bgGradientColors = gfxAdapter.getBackgroundGradientColors();
        int[] bgGradientPercents = gfxAdapter.getBackgroundGradientPercents();
        Boolean bgGradientVertical = gfxAdapter.isBackgroundGradientVertical();
        boolean bl = hasChanged = WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_COLORS, bgGradientColors, null) || WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_PERCENTS, bgGradientPercents, null) || WidgetLCAUtil.hasChanged(folder, PROP_SELECTION_BG_GRADIENT_VERTICAL, bgGradientVertical, Boolean.FALSE);
        if (hasChanged) {
            JsonValue gradient = JsonValue.NULL;
            if (bgGradientColors != null) {
                JsonArray colors = new JsonArray();
                int i = 0;
                while (i < bgGradientColors.length) {
                    colors.add(JsonMapping.toJson(bgGradientColors[i]));
                    ++i;
                }
                JsonArray percents = JsonUtil.createJsonArray(bgGradientPercents);
                gradient = new JsonArray().add(colors).add(percents).add(bgGradientVertical);
            }
            RemoteObjectFactory.getRemoteObject(folder).set(PROP_SELECTION_BG_GRADIENT, gradient);
        }
    }

    private static String getTabPosition(CTabFolder folder) {
        return folder.getTabPosition() == 128 ? DEFAULT_TAB_POSITION : "bottom";
    }

    private static String getMinMaxState(CTabFolder folder) {
        String result = DEFAULT_MIN_MAX_STATE;
        if (folder.getMinimized()) {
            result = "min";
        } else if (folder.getMaximized()) {
            result = "max";
        }
        return result;
    }

    private static Rectangle getMinimizeBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getMinimizeRect();
    }

    private static Rectangle getMaximizeBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getMaximizeRect();
    }

    private static Rectangle getChevronBounds(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getChevronRect();
    }

    private static boolean getChevronVisible(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getChevronVisible();
    }

    private static Color getSelectionBackground(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionBackground();
    }

    private static Color getSelectionForeground(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionForeground();
    }

    private static Image getSelectionBackgroundImage(CTabFolder folder) {
        return CTabFolderLCA.getCTabFolderAdapter(folder).getUserSelectionBackgroundImage();
    }

    private static ICTabFolderAdapter getCTabFolderAdapter(CTabFolder folder) {
        return folder.getAdapter(ICTabFolderAdapter.class);
    }

    private CTabFolderLCA() {
    }
}

