/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StacklessLogging
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(StacklessLogging.class);
    private static final JettyLoggerFactory loggerFactory;
    private final Set<JettyLogger> squelched = new HashSet<JettyLogger>();

    public StacklessLogging(Class<?> ... classesToSquelch) {
        this((String[])Stream.of(classesToSquelch).map(Class::getName).toArray(String[]::new));
    }

    public StacklessLogging(Package ... packagesToSquelch) {
        this((String[])Stream.of(packagesToSquelch).map(Package::getName).toArray(String[]::new));
    }

    public StacklessLogging(String ... loggerNames) {
        this((Logger[])Stream.of(loggerNames).map(loggerFactory::getJettyLogger).toArray(Logger[]::new));
    }

    public StacklessLogging(Logger ... logs) {
        for (Logger log : logs) {
            JettyLogger jettyLogger;
            if (!(log instanceof JettyLogger) || (jettyLogger = (JettyLogger)log).isDebugEnabled() || jettyLogger.isHideStacks()) continue;
            jettyLogger.setHideStacks(true);
            this.squelched.add(jettyLogger);
        }
    }

    @Override
    public void close() {
        for (JettyLogger log : this.squelched) {
            log.setHideStacks(false);
        }
    }

    static {
        JettyLoggerFactory jettyLoggerFactory = null;
        ILoggerFactory activeLoggerFactory = LoggerFactory.getILoggerFactory();
        if (activeLoggerFactory instanceof JettyLoggerFactory) {
            jettyLoggerFactory = (JettyLoggerFactory)activeLoggerFactory;
        } else {
            LOG.warn("Unable to squelch stacktraces ({} is not a {})", (Object)activeLoggerFactory.getClass().getName(), (Object)JettyLoggerFactory.class.getName());
        }
        loggerFactory = jettyLoggerFactory;
    }
}

