/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.context;

import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.registration.EndpointRegistration;
import org.eclipse.equinox.http.servlet.internal.registration.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletResponseWrapperImpl;
import org.eclipse.equinox.http.servlet.internal.servlet.IncludeDispatchResponseWrapper;
import org.eclipse.equinox.http.servlet.internal.servlet.ResponseStateHandler;
import org.eclipse.equinox.http.servlet.internal.util.Params;

public class DispatchTargets {
    private static final String SIMPLE_NAME = DispatchTargets.class.getSimpleName();
    private final ContextController contextController;
    private DispatcherType dispatcherType;
    private final EndpointRegistration<?> endpointRegistration;
    private final List<FilterRegistration> matchingFilterRegistrations;
    private final String pathInfo;
    private Map<String, String[]> parameterMap;
    private String queryString;
    private final String requestURI;
    private final String servletPath;
    private final String servletName;
    private final Map<String, Object> specialOverides = new ConcurrentHashMap<String, Object>();
    private String string;

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, String servletName, String requestURI, String servletPath, String pathInfo, String queryString) {
        this(contextController, endpointRegistration, Collections.emptyList(), servletName, requestURI, servletPath, pathInfo, queryString);
    }

    public DispatchTargets(ContextController contextController, EndpointRegistration<?> endpointRegistration, List<FilterRegistration> matchingFilterRegistrations, String servletName, String requestURI, String servletPath, String pathInfo, String queryString) {
        this.contextController = contextController;
        this.endpointRegistration = endpointRegistration;
        this.matchingFilterRegistrations = matchingFilterRegistrations;
        this.servletName = servletName;
        this.requestURI = requestURI;
        this.servletPath = servletPath == null ? "" : servletPath;
        this.pathInfo = pathInfo;
        this.queryString = queryString;
    }

    public void addRequestParameters(HttpServletRequest request) {
        if (this.queryString == null) {
            this.parameterMap = request.getParameterMap();
            this.queryString = request.getQueryString();
            return;
        }
        Map<String, String[]> parameterMapCopy = DispatchTargets.queryStringToParameterMap(this.queryString);
        for (Map.Entry entry : request.getParameterMap().entrySet()) {
            String[] values = parameterMapCopy.get(entry.getKey());
            values = Params.append(values, (String[])entry.getValue());
            parameterMapCopy.put((String)entry.getKey(), values);
        }
        this.parameterMap = Collections.unmodifiableMap(parameterMapCopy);
    }

    public void doDispatch(HttpServletRequest originalRequest, HttpServletResponse response, String path, DispatcherType requestedDispatcherType) throws ServletException, IOException {
        this.setDispatcherType(requestedDispatcherType);
        RequestAttributeSetter setter = new RequestAttributeSetter((ServletRequest)originalRequest);
        if (this.dispatcherType == DispatcherType.INCLUDE) {
            setter.setAttribute("javax.servlet.include.context_path", this.contextController.getFullContextPath());
            setter.setAttribute("javax.servlet.include.path_info", this.getPathInfo());
            setter.setAttribute("javax.servlet.include.query_string", this.getQueryString());
            setter.setAttribute("javax.servlet.include.request_uri", this.getRequestURI());
            setter.setAttribute("javax.servlet.include.servlet_path", this.getServletPath());
        } else if (this.dispatcherType == DispatcherType.FORWARD) {
            response.resetBuffer();
            setter.setAttribute("javax.servlet.forward.context_path", originalRequest.getContextPath());
            setter.setAttribute("javax.servlet.forward.path_info", originalRequest.getPathInfo());
            setter.setAttribute("javax.servlet.forward.query_string", originalRequest.getQueryString());
            setter.setAttribute("javax.servlet.forward.request_uri", originalRequest.getRequestURI());
            setter.setAttribute("javax.servlet.forward.servlet_path", originalRequest.getServletPath());
        }
        Object request = originalRequest;
        HttpServletRequestWrapperImpl requestWrapper = HttpServletRequestWrapperImpl.findHttpRuntimeRequest(originalRequest);
        HttpServletResponseWrapperImpl responseWrapper = HttpServletResponseWrapperImpl.findHttpRuntimeResponse(response);
        boolean includeWrapperAdded = false;
        try {
            if (requestWrapper == null) {
                requestWrapper = new HttpServletRequestWrapperImpl(originalRequest);
                request = requestWrapper;
            }
            if (responseWrapper == null) {
                responseWrapper = new HttpServletResponseWrapperImpl((HttpServletResponse)response);
                response = responseWrapper;
            }
            requestWrapper.push(this);
            if (this.dispatcherType == DispatcherType.INCLUDE && !(responseWrapper.getResponse() instanceof IncludeDispatchResponseWrapper)) {
                responseWrapper.setResponse((ServletResponse)new IncludeDispatchResponseWrapper((HttpServletResponse)responseWrapper.getResponse()));
                includeWrapperAdded = true;
            }
            ResponseStateHandler responseStateHandler = new ResponseStateHandler((HttpServletRequest)request, (HttpServletResponse)response, this);
            responseStateHandler.processRequest();
        }
        finally {
            if (this.dispatcherType == DispatcherType.INCLUDE && responseWrapper.getResponse() instanceof IncludeDispatchResponseWrapper && includeWrapperAdded) {
                responseWrapper.setResponse(((IncludeDispatchResponseWrapper)responseWrapper.getResponse()).getResponse());
            }
            requestWrapper.pop();
            setter.close();
        }
    }

    public ContextController getContextController() {
        return this.contextController;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcherType;
    }

    public List<FilterRegistration> getMatchingFilterRegistrations() {
        return this.matchingFilterRegistrations;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            return null;
        }
        return String.valueOf(this.getContextController().getFullContextPath()) + this.requestURI;
    }

    public String getServletName() {
        return this.servletName;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public EndpointRegistration<?> getServletRegistration() {
        return this.endpointRegistration;
    }

    public Map<String, Object> getSpecialOverides() {
        return this.specialOverides;
    }

    public void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    public String toString() {
        String value = this.string;
        if (value == null) {
            this.string = value = String.valueOf(SIMPLE_NAME) + '[' + this.contextController.getFullContextPath() + this.requestURI + (this.queryString != null ? String.valueOf('?') + this.queryString : "") + ", " + this.endpointRegistration.toString() + ']';
        }
        return value;
    }

    private static Map<String, String[]> queryStringToParameterMap(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return new HashMap<String, String[]>();
        }
        try {
            String[] parameters;
            LinkedHashMap<String, String[]> parameterMap = new LinkedHashMap<String, String[]>();
            String[] stringArray = parameters = queryString.split("&");
            int n = parameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                int index = parameter.indexOf(61);
                String name = index > 0 ? URLDecoder.decode(parameter.substring(0, index), "UTF-8") : parameter;
                String[] values = (String[])parameterMap.get(name);
                if (values == null) {
                    values = new String[]{};
                }
                String value = index > 0 && parameter.length() > index + 1 ? URLDecoder.decode(parameter.substring(index + 1), "UTF-8") : null;
                values = Params.append(values, value);
                parameterMap.put(name, values);
                ++n2;
            }
            return parameterMap;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static class RequestAttributeSetter
    implements Closeable {
        private final ServletRequest servletRequest;
        private final Map<String, Object> oldValues = new HashMap<String, Object>();

        public RequestAttributeSetter(ServletRequest servletRequest) {
            this.servletRequest = servletRequest;
        }

        public void setAttribute(String name, Object value) {
            this.oldValues.put(name, this.servletRequest.getAttribute(name));
            this.servletRequest.setAttribute(name, value);
        }

        @Override
        public void close() {
            for (Map.Entry<String, Object> oldValue : this.oldValues.entrySet()) {
                if (oldValue.getValue() == null) {
                    this.servletRequest.removeAttribute(oldValue.getKey());
                    continue;
                }
                this.servletRequest.setAttribute(oldValue.getKey(), oldValue.getValue());
            }
        }
    }
}

