/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.registry.internal;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.rap.http.registry.internal.ExtensionPointTracker;
import org.eclipse.rap.http.registry.internal.HttpRegistryManager;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class ServletManager
implements ExtensionPointTracker.Listener {
    private static final String SERVLETS_EXTENSION_POINT = "org.eclipse.equinox.http.registry.servlets";
    private static final String HTTPCONTEXT_NAME = "httpcontext-name";
    private static final String PARAM_VALUE = "value";
    private static final String PARAM_NAME = "name";
    private static final String INIT_PARAM = "init-param";
    private static final String SERVLET = "servlet";
    private static final String ALIAS = "alias";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String HTTPCONTEXT_ID = "httpcontextId";
    private static final String SERVICESELECTOR = "serviceSelector";
    private static final String CLASS = "class";
    private static final String FILTER = "filter";
    private ExtensionPointTracker tracker;
    private HttpRegistryManager httpRegistryManager;
    private List<IConfigurationElement> registered = new ArrayList<IConfigurationElement>();
    private ServiceReference<?> reference;

    public ServletManager(HttpRegistryManager httpRegistryManager, ServiceReference<?> reference, IExtensionRegistry registry) {
        this.httpRegistryManager = httpRegistryManager;
        this.reference = reference;
        this.tracker = new ExtensionPointTracker(registry, SERVLETS_EXTENSION_POINT, this);
    }

    public void start() {
        this.tracker.open();
    }

    public void stop() {
        this.tracker.close();
    }

    @Override
    public void added(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement serviceSelectorElement = iConfigurationElementArray[n2];
            if (SERVICESELECTOR.equals(serviceSelectorElement.getName())) {
                Filter serviceSelector = null;
                String clazz = serviceSelectorElement.getAttribute(CLASS);
                if (clazz != null) {
                    try {
                        serviceSelector = (Filter)serviceSelectorElement.createExecutableExtension(CLASS);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                String filter = serviceSelectorElement.getAttribute(FILTER);
                if (filter == null) {
                    return;
                }
                try {
                    serviceSelector = FrameworkUtil.createFilter((String)filter);
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                    return;
                }
                if (serviceSelector.match(this.reference)) break;
                return;
            }
            ++n2;
        }
        iConfigurationElementArray = elements;
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            IConfigurationElement servletElement = iConfigurationElementArray[n2];
            if (SERVLET.equals(servletElement.getName())) {
                ServletWrapper wrapper = new ServletWrapper(servletElement);
                String alias = servletElement.getAttribute(ALIAS);
                if (alias != null) {
                    String httpContextId;
                    IConfigurationElement[] initParams;
                    Hashtable<String, String> initparams = new Hashtable<String, String>();
                    IConfigurationElement[] iConfigurationElementArray2 = initParams = servletElement.getChildren(INIT_PARAM);
                    int n3 = initParams.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement initParam = iConfigurationElementArray2[n4];
                        String paramName = initParam.getAttribute(PARAM_NAME);
                        String paramValue = initParam.getAttribute(PARAM_VALUE);
                        ((Dictionary)initparams).put(paramName, paramValue);
                        ++n4;
                    }
                    boolean loadOnStartup = Boolean.valueOf(servletElement.getAttribute(LOAD_ON_STARTUP));
                    if (loadOnStartup) {
                        wrapper.setLoadOnStartup();
                    }
                    if ((httpContextId = servletElement.getAttribute(HTTPCONTEXT_ID)) == null) {
                        httpContextId = servletElement.getAttribute(HTTPCONTEXT_NAME);
                    }
                    if (httpContextId != null && httpContextId.indexOf(46) == -1) {
                        httpContextId = String.valueOf(servletElement.getNamespaceIdentifier()) + "." + httpContextId;
                    }
                    if (this.httpRegistryManager.addServletContribution(alias, wrapper, initparams, httpContextId, extension.getContributor())) {
                        this.registered.add(servletElement);
                    }
                }
            }
            ++n2;
        }
    }

    @Override
    public void removed(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement servletElement = iConfigurationElementArray[n2];
            if (this.registered.remove(servletElement)) {
                String alias = servletElement.getAttribute(ALIAS);
                this.httpRegistryManager.removeContribution(alias);
            }
            ++n2;
        }
    }

    private static class ServletWrapper
    implements Servlet {
        private IConfigurationElement element;
        private Servlet delegate;
        private ServletConfig config;
        private boolean loadOnStartup = false;

        public ServletWrapper(IConfigurationElement element) {
            this.element = element;
        }

        public void setLoadOnStartup() {
            this.loadOnStartup = true;
        }

        public void init(ServletConfig servletConfig) throws ServletException {
            this.config = servletConfig;
            if (this.loadOnStartup) {
                this.initializeDelegate();
            }
        }

        public ServletConfig getServletConfig() {
            return this.config;
        }

        public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
            this.initializeDelegate();
            this.delegate.service(arg0, arg1);
        }

        public String getServletInfo() {
            return "";
        }

        public void destroy() {
            this.destroyDelegate();
        }

        private synchronized void initializeDelegate() throws ServletException {
            if (this.delegate == null) {
                try {
                    Servlet newDelegate = (Servlet)this.element.createExecutableExtension(ServletManager.CLASS);
                    newDelegate.init(this.config);
                    this.delegate = newDelegate;
                }
                catch (CoreException e) {
                    throw new ServletException((Throwable)e);
                }
            }
        }

        private synchronized void destroyDelegate() {
            if (this.delegate != null) {
                Servlet doomedDelegate = this.delegate;
                this.delegate = null;
                doomedDelegate.destroy();
            }
        }
    }
}

