/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.Map;
import org.eclipse.eef.EEFTextDescription;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Widget;

public class EEFTextMemento {
    public static final String KEY = "eef.widget.text.memento";
    private final EEFTextDescription description;
    private final Object self;
    private final String referenceValue;
    private final String userInput;

    public EEFTextMemento(EEFTextDescription description, Object self, String referenceValue, String userInput) {
        this.description = description;
        this.self = self;
        this.referenceValue = referenceValue;
        this.userInput = userInput;
    }

    public boolean appliesTo(EEFTextDescription textDescription, Map<String, Object> variables) {
        return this.description == textDescription && this.self == variables.get("self");
    }

    public void store(Widget widget) {
        widget.setData(KEY, (Object)this);
    }

    public static EEFTextMemento of(Widget widget) {
        Object data = widget.getData(KEY);
        if (data instanceof EEFTextMemento) {
            return (EEFTextMemento)data;
        }
        return null;
    }

    public static void remove(Widget widget) {
        widget.setData(KEY, null);
    }

    public EEFTextDescription getDescription() {
        return this.description;
    }

    public String getReferenceValue() {
        return this.referenceValue;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String newLine = "\n";
        sb.append("Desc: " + EcoreUtil.getURI((EObject)this.description)).append(newLine);
        sb.append("Self: " + EcoreUtil.getURI((EObject)((EObject)this.self))).append(newLine);
        sb.append("Reference Value: " + this.referenceValue).append(newLine);
        sb.append("User Input: " + this.userInput).append(newLine);
        sb.append(newLine);
        return sb.toString();
    }
}

