/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RLanguage;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.AbstractRObject;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;

@NonNullByDefault
public class RLanguageImpl
extends AbstractRObject
implements RLanguage,
ExternalizableRObject {
    private byte type;
    private String className1;
    private @Nullable String source;

    public static final String getBaseClassname(byte type) {
        switch (type) {
            case 1: {
                return "name";
            }
            case 3: {
                return "call";
            }
        }
        return "expression";
    }

    public RLanguageImpl(byte type, String source, @Nullable String className1) {
        this.type = type;
        this.className1 = className1 != null ? className1 : RLanguageImpl.getBaseClassname(type);
        this.source = source;
    }

    public RLanguageImpl(byte type, @Nullable String className1) {
        this.type = type;
        this.className1 = className1 != null ? className1 : RLanguageImpl.getBaseClassname(type);
    }

    public RLanguageImpl(RJIO io, RObjectFactory factory) throws IOException {
        this.readExternal(io, factory);
    }

    public void readExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = io.readInt();
        this.type = io.readByte();
        String string = this.className1 = (options & 0x10) != 0 ? io.readString() : RLanguageImpl.getBaseClassname(this.type);
        if ((io.flags & 1) == 0) {
            this.source = io.readString();
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = 0;
        if (!this.className1.equals(RLanguageImpl.getBaseClassname(this.type))) {
            options |= 0x10;
        }
        io.writeInt(options);
        io.writeByte(this.type);
        if ((options & 0x10) != 0) {
            io.writeString(this.className1);
        }
        if ((io.flags & 1) == 0) {
            io.writeString(this.source);
        }
    }

    @Override
    public byte getRObjectType() {
        return 12;
    }

    @Override
    public byte getLanguageType() {
        return this.type;
    }

    @Override
    public String getRClassName() {
        return this.className1;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public @Nullable String getSource() {
        return this.source;
    }

    @Override
    public @Nullable RStore<?> getData() {
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=RLanguage, class=").append(this.getRClassName());
        if (this.source != null) {
            sb.append("\n\tsource: ");
            int idx = this.source.indexOf(10);
            if (idx >= 0) {
                sb.append(this.source.substring(0, idx));
                sb.append(" ...");
            } else {
                sb.append(this.source);
            }
        }
        return sb.toString();
    }
}

