/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.FxCallback;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.util.ServerUtils;

public class FxAuthMethod
extends ServerAuthMethod {
    private File file;
    private FileInputStream fileInputStream;
    private final byte[] pendingKey = new byte[1024];
    private FileChannel fileChannel;

    public FxAuthMethod() {
        super("fx", false);
    }

    @Override
    public void doInit(String arg) throws RjException {
        ServerUtils.ArgKeyValue config = ServerUtils.getArgConfigValue(arg);
        if (config.getKey().equals("file")) {
            String fileName = config.getValue();
            if (fileName == null || fileName.isEmpty()) {
                throw new RjException("Missing lock file name.", null);
            }
            this.file = new File(fileName);
            try {
                if (!this.file.exists()) {
                    this.file.createNewFile();
                }
                this.fileChannel = new RandomAccessFile(this.file, "rws").getChannel();
                this.fileChannel.truncate(512L);
            }
            catch (IOException e) {
                throw new RjException("Cannot read lock file.", e);
            }
        } else {
            throw new RjException(String.format("Unsupported configuration type '%1$s'.", config.getKey()));
        }
    }

    @Override
    protected Callback[] doCreateLogin() throws RjException {
        this.getRandom().nextBytes(this.pendingKey);
        try {
            this.fileChannel.position(this.fileChannel.size());
        }
        catch (IOException e) {
            throw new RjException("Cannot read lock file.", e);
        }
        return new Callback[]{new NameCallback("Username"), new FxCallback(this.file.getPath(), this.pendingKey)};
    }

    @Override
    protected String doPerformLogin(Callback[] callbacks) throws LoginException, RjException {
        String userName = ((NameCallback)callbacks[0]).getName();
        byte[] clientKey = ((FxCallback)callbacks[1]).getContent();
        if (clientKey.length < 1024) {
            throw new RjException("Unsufficient client key");
        }
        try {
            if (this.compare(this.pendingKey) && this.compare(clientKey)) {
                return userName;
            }
        }
        catch (IOException e) {
            throw new RjException("Cannot read lock file.", e);
        }
        throw new FailedLoginException();
    }

    private boolean compare(byte[] key) throws IOException {
        byte[] check = new byte[key.length];
        int n = this.fileChannel.read(ByteBuffer.wrap(check));
        if (n != key.length) {
            return false;
        }
        return Arrays.equals(key, check);
    }
}

