/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.core.Preference;

public class PreferenceStoreBeanWrapper {
    private final IPreferenceStore fStore;
    private final PropertyChangeSupport fBeanSupport;
    private final HashMap<String, PrefData> fPreferenceMap = new HashMap();

    public PreferenceStoreBeanWrapper(IPreferenceStore store, Object bean) {
        this.fStore = store;
        this.fBeanSupport = new PropertyChangeSupport(bean);
        this.fStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String storeKey = event.getProperty();
                PrefData pref = (PrefData)PreferenceStoreBeanWrapper.this.fPreferenceMap.get(storeKey);
                if (pref != null) {
                    Object oldValue = event.getOldValue();
                    Object newValue = event.getNewValue();
                    if (pref.converter != null) {
                        if (!pref.converter.getUsageType().isInstance(oldValue)) {
                            oldValue = pref.converter.store2Usage((String)oldValue);
                        }
                        if (!pref.converter.getUsageType().isInstance(newValue)) {
                            newValue = pref.converter.store2Usage((String)newValue);
                        }
                    }
                    PreferenceStoreBeanWrapper.this.fBeanSupport.firePropertyChange(pref.beanProperty, oldValue, newValue);
                }
            }
        });
    }

    public void addPreference(String beanProperty, Preference preference) {
        this.fPreferenceMap.put(preference.getKey(), new PrefData(beanProperty, preference));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.fBeanSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.fBeanSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.fBeanSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.fBeanSupport.removePropertyChangeListener(propertyName, listener);
    }

    private static class PrefData {
        final String beanProperty;
        final Preference converter;

        public PrefData(String beanProperty, Preference converter) {
            this.beanProperty = beanProperty;
            this.converter = converter;
        }
    }
}

