/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ColorManager
implements Disposable {
    protected Map<String, RGB> fKeyTable = new HashMap<String, RGB>(10);
    protected Map<Display, Map<RGB, Color>> fDisplayTable = new HashMap<Display, Map<RGB, Color>>(2);
    private final boolean fAutoDisposeOnDisplayDispose;
    private final Listener fDisposeListener = new Listener(){

        public void handleEvent(Event event) {
            ColorManager.this.dispose(event.display);
        }
    };

    public ColorManager() {
        this(true);
    }

    private ColorManager(boolean autoDisposeOnDisplayDispose) {
        this.fAutoDisposeOnDisplayDispose = autoDisposeOnDisplayDispose;
    }

    public void dispose() {
        Iterator<Display> iterator = this.fDisplayTable.keySet().iterator();
        while (iterator.hasNext()) {
            Display display;
            final Display ref = display = iterator.next();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ColorManager.this.dispose(ref);
                }
            });
        }
    }

    private void dispose(Display display) {
        display.removeListener(12, this.fDisposeListener);
        Map<RGB, Color> colorTable = this.fDisplayTable.remove(display);
        if (colorTable != null) {
            for (Color color : colorTable.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        Display display = Display.getCurrent();
        Map<RGB, Color> colorTable = this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.addListener(12, this.fDisposeListener);
            }
        }
        if ((color = colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    public void bindColor(String key, RGB rgb) {
        this.fKeyTable.put(key, rgb);
    }
}

