/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.components;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.workbench.ContextHandlers;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;

public class History<E> {
    private static final int HISTORY_SIZE = 100;
    private static final int HISTORY_SHOWN = 10;
    private final List<E> list = new ArrayList(100);
    private int currentPosition = -1;
    private boolean currentPositionSelected;
    private IServiceLocator serviceLocator;
    private ContextHandlers handlers;
    private ISelectionProvider selectionProvider;

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void addActions(IServiceLocator serviceLocator, ContextHandlers handlers, ToolBarManager toolBar) {
        this.serviceLocator = serviceLocator;
        this.handlers = handlers;
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        NavigateHandler handler = new NavigateHandler(-1);
        toolBar.add((IContributionItem)new NavigateDropdownContribItem(this, new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.backwardHistory", null, sharedImages.getImageDescriptor("IMG_TOOL_BACK"), sharedImages.getImageDescriptor("IMG_TOOL_BACK_DISABLED"), null, null, null, null, 4, null, false), (IHandler2)handler){

            @Override
            protected void addItems(IMenuManager menuManager) {
                if (currentPosition < 0) {
                    return;
                }
                int last = currentPosition;
                if (!currentPositionSelected) {
                    ++last;
                }
                if (last > 10) {
                    last = 10;
                }
                last = -last;
                int relPos = -1;
                while (relPos >= last) {
                    this.addItem(menuManager, relPos);
                    --relPos;
                }
            }
        });
        this.handlers.addActivate("org.eclipse.ui.navigate.backwardHistory", (IHandler2)handler);
        handler = new NavigateHandler(1);
        toolBar.add((IContributionItem)new NavigateDropdownContribItem(this, new CommandContributionItemParameter(serviceLocator, null, "org.eclipse.ui.navigate.forwardHistory", null, sharedImages.getImageDescriptor("IMG_TOOL_FORWARD"), sharedImages.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"), null, null, null, null, 4, null, false), (IHandler2)handler){

            @Override
            protected void addItems(IMenuManager menuManager) {
                if (currentPosition < 0) {
                    return;
                }
                int last = list.size() - currentPosition - 1;
                if (last > 10) {
                    last = 10;
                }
                int relPos = 1;
                while (relPos <= last) {
                    menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(this.getServiceLocator(), null, "NO_COMMAND", 8), (IHandler2)new NavigateHandler(relPos)));
                    ++relPos;
                }
            }
        });
        this.handlers.addActivate("org.eclipse.ui.navigate.forwardHistory", (IHandler2)handler);
    }

    public void selected(E entry) {
        if (entry == null) {
            this.currentPositionSelected = false;
        } else if (this.currentPosition < 0 || !this.list.get(this.currentPosition).equals(entry)) {
            this.list.subList(this.currentPosition + 1, this.list.size()).clear();
            if (this.list.size() >= 100) {
                this.list.remove(0);
                --this.currentPosition;
            }
            this.list.add(entry);
            ++this.currentPosition;
            this.currentPositionSelected = true;
        }
        this.updateControls();
    }

    protected int getPosition(int relPos) {
        int pos = this.currentPosition + relPos;
        if (!this.currentPositionSelected && relPos < 0) {
            ++pos;
        }
        return pos;
    }

    public void select(int relPos) {
        int pos = this.getPosition(relPos);
        if (pos >= 0 && pos < this.list.size()) {
            this.currentPosition = pos;
            this.updateControls();
            this.select(this.list.get(pos));
        }
    }

    protected void select(E entry) {
        this.selectionProvider.setSelection((ISelection)new StructuredSelection(entry));
    }

    protected String getLabel(E entry) {
        return entry.toString();
    }

    protected void updateControls() {
        if (this.serviceLocator != null) {
            WorkbenchUIUtils.refreshCommandElements("org.eclipse.ui.navigate.backwardHistory", this.handlers.get("org.eclipse.ui.navigate.backwardHistory"), null);
            WorkbenchUIUtils.refreshCommandElements("org.eclipse.ui.navigate.forwardHistory", this.handlers.get("org.eclipse.ui.navigate.forwardHistory"), null);
        }
    }

    private abstract class NavigateDropdownContribItem
    extends HandlerContributionItem {
        public NavigateDropdownContribItem(CommandContributionItemParameter contributionParameters, IHandler2 handler) {
            super(contributionParameters, handler);
        }

        @Override
        protected void initDropDownMenu(final MenuManager menuManager) {
            menuManager.addMenuListener((IMenuListener)new IMenuListener2(){

                public void menuAboutToShow(IMenuManager manager) {
                    NavigateDropdownContribItem.this.addItems((IMenuManager)menuManager);
                }

                public void menuAboutToHide(IMenuManager manager) {
                    NavigateDropdownContribItem.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            menuManager.dispose();
                        }
                    });
                }
            });
        }

        protected abstract void addItems(IMenuManager var1);

        protected void addItem(IMenuManager menuManager, int relPos) {
            menuManager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter(this.getServiceLocator(), null, "NO_COMMAND", 8), (IHandler2)new NavigateHandler(relPos)));
        }
    }

    private class NavigateHandler
    extends AbstractHandler
    implements IElementUpdater {
        private final int relPos;

        public NavigateHandler(int relPos) {
            this.relPos = relPos;
        }

        public void setEnabled(Object evaluationContext) {
            int pos = History.this.getPosition(this.relPos);
            this.setBaseEnabled(pos >= 0 && pos < History.this.list.size());
        }

        public Object execute(ExecutionEvent event) throws ExecutionException {
            History.this.select(this.relPos);
            return null;
        }

        public void updateElement(UIElement element, Map parameters) {
            WorkbenchUIUtils.aboutToUpdateCommandsElements((IHandler2)this, element);
            try {
                int pos = History.this.getPosition(this.relPos);
                if (pos >= 0 && pos < History.this.list.size()) {
                    String label = History.this.getLabel(History.this.list.get(pos));
                    this.setBaseEnabled(true);
                    element.setText(label);
                    element.setTooltip(NLS.bind((String)(this.relPos <= 0 ? SharedMessages.NavigateBack_1_tooltip : SharedMessages.NavigateForward_1_tooltip), (Object)label));
                } else {
                    this.setBaseEnabled(false);
                    element.setText(null);
                    element.setTooltip(null);
                }
            }
            finally {
                WorkbenchUIUtils.finalizeUpdateCommandsElements((IHandler2)this);
            }
        }
    }
}

