/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.ecommons.collections.FastList;

public abstract class AbstractPostSelectionProvider
implements IPostSelectionProvider {
    private final FastList<ISelectionChangedListener> fSelectionListeners = new FastList(ISelectionChangedListener.class);
    private final FastList<ISelectionChangedListener> fPostSelectionListeners = new FastList(ISelectionChangedListener.class);

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionListeners.add((Object)listener);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        this.fPostSelectionListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        ISelectionChangedListener[] listeners = (ISelectionChangedListener[])this.fSelectionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    protected void firePostSelectionChanged(final SelectionChangedEvent event) {
        ISelectionChangedListener[] listeners = (ISelectionChangedListener[])this.fPostSelectionListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }
}

