/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.internal.docmlet.tex.core.BasicTexCoreAccess;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxModelManagerImpl;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.osgi.framework.BundleContext;

public class TexCorePlugin
extends Plugin {
    private static TexCorePlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private BasicTexCoreAccess workbenchCoreAccess;
    private BasicTexCoreAccess defaultsCoreAccess;
    private LtxModelManagerImpl ltxModelManager;

    public static TexCorePlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        TexCorePlugin plugin = TexCorePlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.workbenchCoreAccess = new BasicTexCoreAccess(PreferenceUtils.getInstancePrefs());
        this.ltxModelManager = new LtxModelManagerImpl();
        this.disposables.add(this.ltxModelManager);
        TexCorePlugin texCorePlugin = this;
        synchronized (texCorePlugin) {
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            TexCorePlugin texCorePlugin = this;
            synchronized (texCorePlugin) {
                this.started = false;
                this.ltxModelManager = null;
            }
            if (this.workbenchCoreAccess != null) {
                this.workbenchCoreAccess.dispose();
                this.workbenchCoreAccess = null;
            }
            if (this.defaultsCoreAccess != null) {
                this.defaultsCoreAccess.dispose();
                this.defaultsCoreAccess = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    TexCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    private void checkStarted() {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
    }

    public LtxModelManagerImpl getLtxModelManager() {
        return this.ltxModelManager;
    }

    public TexCoreAccess getWorkbenchAccess() {
        return this.workbenchCoreAccess;
    }

    public synchronized TexCoreAccess getDefaultsAccess() {
        if (this.defaultsCoreAccess == null) {
            this.checkStarted();
            this.defaultsCoreAccess = new BasicTexCoreAccess(PreferenceUtils.getDefaultPrefs());
        }
        return this.defaultsCoreAccess;
    }
}

