/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;

@NonNullByDefault
public abstract class AbstractToolHandler<TTool extends Tool>
extends AbstractHandler
implements ActiveToolListener {
    protected static final byte S_INITIALIZING = 0;
    protected static final byte S_INITIALIZED = 1;
    protected static final byte S_DISPOSED = -1;
    private byte state;
    private final @Nullable String requiredMainType;
    private final @Nullable String requiredFeatureSet;
    private final @Nullable ToolProvider toolProvider;
    private final @Nullable IServiceLocator serviceLocator;
    private @Nullable TTool activeTool;

    protected AbstractToolHandler(@Nullable String mainType, @Nullable String featureSet, @Nullable ToolProvider toolProvider, @Nullable IServiceLocator serviceLocator) {
        this.requiredMainType = mainType;
        this.requiredFeatureSet = featureSet;
        this.toolProvider = toolProvider;
        this.serviceLocator = serviceLocator;
        this.state = 0;
    }

    protected AbstractToolHandler(@Nullable String mainType, @Nullable String featureSet) {
        this(mainType, featureSet, null, null);
    }

    protected AbstractToolHandler(@Nullable String mainType) {
        this(mainType, null, null, null);
    }

    protected final int getState() {
        return this.state;
    }

    protected void init() {
        if (this.toolProvider != null) {
            this.toolProvider.addToolListener((ActiveToolListener)this);
        }
        this.state = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.state == -1) {
            return;
        }
        AbstractToolHandler abstractToolHandler = this;
        synchronized (abstractToolHandler) {
            this.state = (byte)-1;
        }
        if (this.toolProvider != null) {
            this.toolProvider.removeToolListener((ActiveToolListener)this);
        }
        super.dispose();
    }

    protected @Nullable Tool getTool(@Nullable Object evaluationContext) {
        if (this.toolProvider != null) {
            return this.toolProvider.getTool();
        }
        return (Tool)HandlerUtil.getVariable((Object)evaluationContext, (String)"org.eclipse.statet.activeTool");
    }

    public void onToolChanged(ActiveToolListener.ActiveToolEvent event) {
        if (this.state == -1) {
            return;
        }
        this.setEnabled(null);
    }

    protected boolean isValid(@Nullable Tool tool) {
        return !(tool == null || this.requiredMainType != null && tool.getMainType() != this.requiredMainType || this.requiredFeatureSet != null && !tool.isProvidingFeatureSet(this.requiredFeatureSet));
    }

    protected boolean evaluateIsEnabled(TTool tool, @Nullable Object evaluationContext) {
        return !tool.isTerminated();
    }

    public void setEnabled(@Nullable Object evaluationContext) {
        Tool tool = this.getTool(evaluationContext);
        this.activeTool = this.isValid(tool) ? tool : null;
        this.setBaseEnabled(this.activeTool != null && this.evaluateIsEnabled(this.activeTool, evaluationContext));
    }

    protected @Nullable TTool getActiveTool() {
        return this.activeTool;
    }

    protected IServiceLocator getServiceLocator(@Nullable Object evaluationContext) {
        if (this.serviceLocator != null) {
            return this.serviceLocator;
        }
        return WorkbenchUIUtils.getServiceLocator((Object)evaluationContext);
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        Tool execTool;
        Tool tool = this.getTool(event.getApplicationContext());
        if ((tool == this.activeTool || this.isValid(tool)) && this.evaluateIsEnabled(execTool = tool, event.getApplicationContext())) {
            return this.execute(execTool, event);
        }
        return null;
    }

    protected abstract @Nullable Object execute(TTool var1, ExecutionEvent var2) throws ExecutionException;
}

