/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.statet.internal.r.ui.search.Messages;
import org.eclipse.statet.internal.r.ui.search.RElementSearch;
import org.eclipse.statet.internal.r.ui.search.RElementSearchResult;

public class RElementSearchQuery
implements ISearchQuery {
    private final RElementSearch searchProcessor;
    private final String displayName;
    private RElementSearchResult result;

    public RElementSearchQuery(RElementSearch searchProcessor) {
        this.searchProcessor = searchProcessor;
        this.displayName = searchProcessor.getElementName().getDisplayName();
    }

    public String getLabel() {
        return Messages.Search_Query_label;
    }

    public String getSearchLabel() {
        return "'" + this.displayName + "'";
    }

    public String getScopeLabel() {
        return this.searchProcessor.getModeLabel();
    }

    public String getMatchLabel(int count) {
        if (this.searchProcessor.searchWrite()) {
            return count == 1 ? Messages.Search_WriteOccurrence_sing_label : Messages.Search_WriteOccurrence_plural_label;
        }
        return count == 1 ? Messages.Search_Occurrence_sing_label : Messages.Search_Occurrence_plural_label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
        RElementSearchQuery rElementSearchQuery = this;
        synchronized (rElementSearchQuery) {
            if (this.result == null) {
                this.result = new RElementSearchResult(this);
            }
            this.searchProcessor.result = this.result;
        }
        try {
            this.searchProcessor.run(SubMonitor.convert((IProgressMonitor)monitor));
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            return new Status(4, "org.eclipse.statet.r.ui", NLS.bind((String)Messages.Search_error_RunFailed_message, (Object)this.getSearchLabel()), (Throwable)e);
        }
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISearchResult getSearchResult() {
        RElementSearchQuery rElementSearchQuery = this;
        synchronized (rElementSearchQuery) {
            if (this.result == null) {
                this.result = new RElementSearchResult(this);
            }
            return this.result;
        }
    }
}

