/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs.groups;

import java.util.Arrays;
import org.eclipse.statet.ecommons.ui.dialogs.groups.Layouter;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ButtonGroup {
    private Composite fComposite;
    private Button[] fButtons;
    private final String[] fButtonsLabel;
    private final boolean[] fButtonsEnabled;
    private final ButtonListener fListener;

    public ButtonGroup(String[] buttonsLabel, ButtonListener listener) {
        this.fButtonsLabel = buttonsLabel;
        this.fButtonsEnabled = new boolean[this.fButtonsLabel.length];
        Arrays.fill(this.fButtonsEnabled, true);
        this.fListener = listener;
    }

    public void createGroup(Layouter layouter) {
        this.fComposite = layouter.composite;
        SelectionListener listener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ButtonGroup.this.doButtonSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ButtonGroup.this.doButtonSelected(e);
            }
        };
        this.fButtons = new Button[this.fButtonsLabel.length];
        int i = 0;
        while (i < this.fButtonsLabel.length) {
            if (this.fButtonsLabel[i] != null) {
                this.fButtons[i] = layouter.addButton(this.fButtonsLabel[i], listener);
                this.fButtons[i].setEnabled(this.fButtonsEnabled[i]);
            } else {
                layouter.addFiller();
            }
            ++i;
        }
    }

    public void doButtonSelected(SelectionEvent event) {
        int i = 0;
        while (i < this.fButtons.length) {
            if (event.widget == this.fButtons[i]) {
                this.fListener.handleButtonPressed(i);
                return;
            }
            ++i;
        }
    }

    public void enableButton(int buttonIdx, boolean enable) {
        this.fButtonsEnabled[buttonIdx] = enable;
        if (this.fComposite.isEnabled()) {
            this.fButtons[buttonIdx].setEnabled(enable);
        }
    }

    public void updateButtonStatet() {
        if (this.fButtons == null || !UIAccess.isOkToUse((Control)this.fComposite)) {
            return;
        }
        boolean global = this.fComposite.isEnabled();
        int i = 0;
        while (i < this.fButtons.length) {
            if (UIAccess.isOkToUse((Control)this.fButtons[i])) {
                this.fButtons[i].setEnabled(global && this.fButtonsEnabled[i]);
            }
            ++i;
        }
    }

    public boolean isButtonEnabled(int idx) {
        return this.fButtonsEnabled[idx];
    }

    public static interface ButtonListener {
        public void handleButtonPressed(int var1);
    }
}

