/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class BackgroundPainter
extends CellPainterWrapper {
    public BackgroundPainter() {
    }

    public BackgroundPainter(ICellPainter painter) {
        super(painter);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle bounds, IConfigRegistry configRegistry) {
        Color backgroundColor = this.getBackgroundColour(cell, configRegistry);
        if (backgroundColor != null) {
            Color originalBackground = gc.getBackground();
            gc.setBackground(backgroundColor);
            gc.fillRectangle(GraphicsUtils.safe(bounds));
            gc.setBackground(originalBackground);
        }
        super.paintCell(cell, gc, bounds, configRegistry);
    }

    protected Color getBackgroundColour(ILayerCell cell, IConfigRegistry configRegistry) {
        return CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR);
    }
}

