/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BlockTextSelection;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.SourceEditorTextHandler;

public class DeletePreviousWordHandler
extends SourceEditorTextHandler {
    public DeletePreviousWordHandler(ISourceEditor editor) {
        super(editor);
    }

    @Override
    protected int getTextActionId() {
        return 262152;
    }

    @Override
    protected void exec(SourceEditorTextHandler.ExecData data) throws BadLocationException {
        if (data.getWidget().getBlockSelection()) {
            int newDocOffset;
            BlockTextSelection blockSelection = (BlockTextSelection)data.getViewer().getSelection();
            if (blockSelection.getEndColumn() > blockSelection.getStartColumn() || data.getCaretDocOffset() == data.getCaretDocLineStartOffset()) {
                data.getWidget().invokeAction(8);
                return;
            }
            if (blockSelection.getStartColumn() > data.getCaretDocLineInformation().getLength()) {
                if (blockSelection.getStartLine() == blockSelection.getEndLine()) {
                    data.getWidget().invokeAction(0x1000008);
                    return;
                }
                newDocOffset = data.getCaretDocLineEndOffset();
            } else {
                newDocOffset = this.findPreviousWordOffset(data, data.getCaretDocOffset(), true);
            }
            int newWidgetOffset = data.toWidgetOffset(newDocOffset);
            if (data.getCaretWidgetOffset() != newWidgetOffset && newWidgetOffset >= 0) {
                this.expandBlockSelection(data, newWidgetOffset);
                data.getWidget().invokeAction(8);
            }
        } else if (data.getWidget().getSelectionCount() > 0) {
            data.getWidget().invokeAction(8);
        } else {
            int newDocOffset = this.findPreviousWordOffset(data, data.getCaretDocOffset(), false);
            Region docRegion = new Region(newDocOffset, data.getCaretDocOffset() - newDocOffset);
            this.delete(data, (IRegion)docRegion);
        }
    }
}

