/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.folding;

import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.statet.ltk.ui.sourceediting.folding.AbstractFoldingPosition;

public final class FoldingAnnotation
extends ProjectionAnnotation {
    static final int EXPANDED_STATE = 1;
    static final int COLLAPSED_STATE = 2;
    private final String type;
    private int initialState;
    private final AbstractFoldingPosition<?> position;

    public FoldingAnnotation(String type, boolean collapse, AbstractFoldingPosition<?> position) {
        super(collapse);
        this.type = type;
        this.initialState = collapse ? 2 : 1;
        this.position = position;
    }

    int getInitialState() {
        return this.initialState;
    }

    int getState() {
        return this.isCollapsed() ? 2 : 1;
    }

    void applyState(int state) {
        switch (state) {
            case 1: {
                this.markExpanded();
                break;
            }
            case 2: {
                this.markCollapsed();
            }
        }
    }

    public AbstractFoldingPosition<?> getPosition() {
        return this.position;
    }

    protected boolean update(FoldingAnnotation newAnn) {
        if (this.type == newAnn.type && ((Object)((Object)newAnn)).getClass() == FoldingAnnotation.class && ((Object)this.position).getClass() == ((Object)newAnn.position).getClass() && this.position.update(newAnn.position)) {
            this.initialState = newAnn.initialState;
            return true;
        }
        return false;
    }
}

