/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.CharCodepointIterator;

public class DocumentCodepointIterator
extends CharCodepointIterator {
    private static int FRAGMENT_LENGTH = 2048;
    private static int FRAGMENT_ADDITION = 64;
    private final IDocument fDocument;
    private int fFragmentOffset;
    private String fFragment;

    public static CharCodepointIterator create(IDocument document, int beginIndex, int endIndex) throws BadLocationException {
        if (endIndex - beginIndex <= FRAGMENT_LENGTH + FRAGMENT_ADDITION) {
            return DocumentCodepointIterator.create(document.get(beginIndex, endIndex - beginIndex), beginIndex, beginIndex, endIndex);
        }
        return new DocumentCodepointIterator(document, beginIndex, endIndex);
    }

    public static CharCodepointIterator create(IDocument document) throws BadLocationException {
        return DocumentCodepointIterator.create(document, 0, document.getLength());
    }

    protected DocumentCodepointIterator(IDocument doc, int beginIndex, int endIndex) throws BadLocationException {
        super(beginIndex, endIndex);
        this.fDocument = doc;
        this.fFragmentOffset = Integer.MIN_VALUE;
    }

    @Override
    protected char getChar(int offset, byte prepare) {
        int offsetInFragment = offset - this.fFragmentOffset;
        if (offsetInFragment < 0 || offsetInFragment >= FRAGMENT_LENGTH) {
            this.fFragmentOffset = (prepare & 1) != 0 || (prepare & 1) == 0 && offset < this.fFragmentOffset ? Math.max(offset - FRAGMENT_LENGTH + FRAGMENT_ADDITION, this.getBeginIndex()) : Math.max(offset - FRAGMENT_ADDITION, this.getBeginIndex());
            try {
                this.fFragment = this.fDocument.get(this.fFragmentOffset, Math.min(FRAGMENT_LENGTH, this.getEndIndex() - this.fFragmentOffset));
                offsetInFragment = offset - this.fFragmentOffset;
            }
            catch (BadLocationException e) {
                this.fFragmentOffset = Integer.MIN_VALUE;
                this.fFragment = null;
                return '\uffff';
            }
        }
        return this.fFragment.charAt(offsetInFragment);
    }

    public String toString() {
        try {
            return this.fDocument.get(this.getBeginIndex(), this.getEndIndex() - this.getBeginIndex());
        }
        catch (BadLocationException e) {
            return e.getMessage();
        }
    }
}

