/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.statet.internal.ecommons.debug.core.ECommonsDebugCorePlugin;
import org.eclipse.statet.jcommons.collections.CopyOnWriteListSet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;

public class LaunchConfigurationCollector
implements ILaunchConfigurationListener,
Disposable {
    private final ILaunchConfigurationType type;
    private final CopyOnWriteListSet<ILaunchConfiguration> configurations = new CopyOnWriteListSet();

    public LaunchConfigurationCollector(String typeId) {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        this.type = launchManager.getLaunchConfigurationType(typeId);
        launchManager.addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = launchManager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                this.launchConfigurationAdded(configuration);
                ++n2;
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
    }

    public void dispose() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        if (launchManager != null) {
            launchManager.removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        }
    }

    protected final ILaunchConfigurationType getLaunchConfigurationType() {
        return this.type;
    }

    protected boolean include(ILaunchConfiguration configuration) throws CoreException {
        return this.type.equals(configuration.getType());
    }

    public final ImList<ILaunchConfiguration> getConfigurations() {
        return this.configurations.toList();
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        try {
            if (this.include(configuration)) {
                this.configurations.add((Object)configuration);
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        try {
            if (this.include(configuration)) {
                this.configurations.add((Object)configuration);
            } else {
                this.configurations.remove((Object)configuration);
            }
        }
        catch (CoreException e) {
            this.log(e);
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.configurations.remove((Object)configuration);
    }

    protected void log(CoreException e) {
        ECommonsDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.debug.core", "An error occurred when checking launch configurations.", (Throwable)e));
    }
}

