/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.rmi.eplatform;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.statet.internal.jcommons.runtime.eplatform.EPlatformAppEnvironment;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.runtime.bundle.BundleEntry;
import org.eclipse.statet.jcommons.runtime.bundle.BundleSpec;
import org.eclipse.statet.jcommons.status.MultiStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.osgi.framework.Bundle;

@NonNullByDefault
public class EPlatformContributor {
    private static final String EXTENSIONPOINT_ID = "org.eclipse.statet.jcommons.rmi.ERegistry";

    private static void log(IStatus status) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.statet.jcommons.util")).log(status);
    }

    public List<URI> addCodebaseEntries(List<URI> entries) {
        LinkedHashSet<BundleEntry> resolved = new LinkedHashSet<BundleEntry>();
        ArrayList<Status> statusCollector = new ArrayList<Status>();
        List<String> pluginIds = this.collectPluginIds(EXTENSIONPOINT_ID, "codebaseEntry");
        EPlatformAppEnvironment appEnv = EPlatformAppEnvironment.getInstance();
        for (String pluginId : pluginIds) {
            appEnv.resolveBundle(new BundleSpec(pluginId), resolved, statusCollector);
        }
        for (BundleEntry entry : resolved) {
            entries.add(entry.getJClassPath().toUri());
        }
        if (!statusCollector.isEmpty()) {
            EPlatformContributor.log(EStatusUtils.convert(new MultiStatus("org.eclipse.statet.jcommons.util", "An error occurred when looking up RJ libraries. This may cause problems starting/running RJ.", null, ImCollections.toList(statusCollector))));
        }
        return entries;
    }

    private List<String> collectPluginIds(String extensionPointId, String entryId) {
        IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor(extensionPointId);
        ArrayList<String> pluginIds = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String pluginId;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals(entryId) && (pluginId = element.getAttribute("pluginId")) != null && pluginId.length() > 0 && !pluginIds.contains(pluginId)) {
                pluginIds.add(pluginId);
            }
            ++n2;
        }
        return pluginIds;
    }
}

