/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.CombinedFactory;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.REnvironment;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;

public final class REnvironmentVar
extends BasicCombinedRElement
implements REnvironment,
RProcessREnvironment,
ExternalizableRObject,
RFrame {
    private String className1;
    private String environmentName;
    private String combinedName;
    private int specialType;
    private long handle;
    private int length;
    private BasicCombinedRElement[] components;
    private RCharacter32Store namesAttribute;
    private int frameType;
    private RProcess source;
    private int stamp;
    private int loadOptions;

    public REnvironmentVar(String envName, boolean isSearch, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) {
        super(parent, name);
        if (envName != null) {
            if (envName.equals("base") || envName.equals("package:base")) {
                this.specialType = 1;
            } else if (envName.startsWith("package:")) {
                this.specialType = 5;
            } else if (envName.equals(".GlobalEnv") || envName.equals("R_GlobalEnv")) {
                this.specialType = 7;
            } else if (envName.equals("Autoloads")) {
                this.specialType = 2;
            }
        }
        this.setEnvName(envName, isSearch);
    }

    public REnvironmentVar(int specialType, String envName, @Nullable BasicCombinedRElement parent, RElementName name, int length, BasicCombinedRElement[] components, RCharacter32Store names) {
        super(parent, name);
        this.specialType = specialType;
        this.setEnvName(envName, false);
        this.length = length;
        this.components = components;
        this.namesAttribute = names;
    }

    public REnvironmentVar(RJIO io, CombinedFactory factory, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        super(parent, name);
        int options = io.readInt();
        this.specialType = (byte)(options >>> 24 & 0xFF);
        this.className1 = (options & 0x10) != 0 ? io.readString() : "environment";
        this.handle = io.readLong();
        this.setEnvName(io.readString(), false);
        int l = this.length = (int)io.readVULong((byte)(options & 7));
        if ((options & 0x20) != 0) {
            this.namesAttribute = null;
            this.components = null;
        } else {
            this.namesAttribute = new RCharacter32Store(io, l);
            this.components = new BasicCombinedRElement[l];
            int i = 0;
            while (i < l) {
                this.components[i] = factory.readObject(io, this, RElementName.create((int)17, (String)this.namesAttribute.getChar(i)));
                ++i;
            }
        }
        if (this.getElementName() == null) {
            String envName = this.getEnvironmentName();
            this.setElementName(RElementName.create((int)16, (String)(envName != null ? envName : "")));
        }
    }

    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        boolean customClass;
        int l = this.length;
        int options = io.getVULongGrade((long)l);
        options |= this.specialType << 24;
        boolean bl = customClass = !this.className1.equals("environment");
        if (customClass) {
            options |= 0x10;
        }
        if (this.components == null) {
            options |= 0x20;
        }
        io.writeInt(options);
        if (customClass) {
            io.writeString(this.className1);
        }
        io.writeLong(this.handle);
        io.writeString(this.combinedName);
        io.writeVULong((byte)(options & 7), (long)l);
        if (this.components != null) {
            this.namesAttribute.writeExternal(io);
            int i = 0;
            while (i < this.length) {
                factory.writeObject((RObject)this.components[i], io);
                ++i;
            }
        }
    }

    public void setSource(RProcess source, int stamp, int loadOptions) {
        this.source = source;
        this.stamp = stamp;
        this.loadOptions = loadOptions;
    }

    @Override
    public RProcess getSource() {
        return this.source;
    }

    @Override
    public int getStamp() {
        return this.stamp;
    }

    public int getLoadOptions() {
        return this.loadOptions;
    }

    protected void setEnvName(String envName, boolean isSearch) {
        switch (this.specialType) {
            case 1: {
                this.environmentName = "base";
                this.frameType = 2;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)38, (String)"base"));
                }
                return;
            }
            case 2: {
                this.environmentName = "Autoloads";
                this.frameType = 4;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)37, (String)"Autoloads"));
                }
                return;
            }
            case 5: {
                assert (envName != null && envName.startsWith("package:"));
                this.environmentName = envName;
                this.frameType = 2;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)38, (String)envName.substring(8)));
                }
                return;
            }
            case 7: {
                this.environmentName = "R_GlobalEnv";
                this.frameType = 1;
                if (this.getElementName() == null) {
                    this.setElementName(RModel.GLOBAL_ENV_NAME);
                }
                return;
            }
            case 9: {
                this.environmentName = "R_EmptyEnv";
                this.frameType = 4;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)16, (String)"R_EmptyEnv"));
                }
                return;
            }
            case 11: {
                assert (envName != null);
                this.environmentName = envName;
                this.frameType = 2;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)34, (String)envName));
                }
                return;
            }
            case 12: {
                assert (envName != null);
                this.environmentName = envName;
                this.frameType = 2;
                if (this.getElementName() == null) {
                    this.setElementName(RElementName.create((int)33, (String)envName));
                }
                return;
            }
        }
        this.environmentName = envName;
        this.frameType = 4;
        if (this.getElementName() == null) {
            this.setElementName(RElementName.create((int)(isSearch ? 37 : 16), (String)envName));
        }
    }

    public final byte getRObjectType() {
        return 8;
    }

    public String getRClassName() {
        return this.className1;
    }

    public int getSpecialType() {
        return this.specialType;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public long getHandle() {
        return this.handle;
    }

    public long getLength() {
        return this.length;
    }

    public RCharacterStore getNames() {
        return this.namesAttribute;
    }

    public String getName(int idx) {
        return this.namesAttribute.getChar(idx);
    }

    public String getName(long idx) {
        return this.namesAttribute.getChar(idx);
    }

    public @Nullable CombinedRElement get(int idx) {
        return this.components[idx];
    }

    public @Nullable CombinedRElement get(long idx) {
        if (idx < 0L || idx >= (long)this.length) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        return this.components[(int)idx];
    }

    public @Nullable CombinedRElement get(String name) {
        int idx = this.namesAttribute.indexOf(name, 0);
        if (idx >= 0) {
            return this.components[idx];
        }
        return null;
    }

    public @Nullable RStore<?> getData() {
        return null;
    }

    public int getElementType() {
        return 1552;
    }

    public boolean hasModelChildren(@Nullable LtkModelElementFilter filter) {
        if (this.components == null) {
            return false;
        }
        if (filter == null) {
            return this.components.length > 0;
        }
        BasicCombinedRElement[] basicCombinedRElementArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public List<? extends CombinedRElement> getModelChildren(@Nullable LtkModelElementFilter filter) {
        if (this.components == null) {
            return Collections.emptyList();
        }
        if (filter == null) {
            return ImCollections.newList((Object[])this.components);
        }
        ArrayList<BasicCombinedRElement> list = new ArrayList<BasicCombinedRElement>();
        BasicCombinedRElement[] basicCombinedRElementArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            BasicCombinedRElement component = basicCombinedRElementArray[n2];
            if (filter.include((LtkModelElement)component)) {
                list.add(component);
            }
            ++n2;
        }
        return list;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public boolean containsElement(String name) {
        return this.namesAttribute.contains(name);
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RFrame.class) {
            return (T)this;
        }
        return super.getAdapter(adapterType);
    }

    public void setError(String message) {
        this.setElementName(RElementName.create((int)16, (String)this.environmentName));
        this.components = new BasicCombinedRElement[0];
        this.namesAttribute = new RCharacter32Store();
        this.combinedName = String.valueOf(this.combinedName) + " (" + message + ")";
    }

    public @Nullable String getFrameId() {
        return null;
    }

    public @Nullable List<? extends RElement> getModelElements() {
        return null;
    }

    public @Nullable List<? extends RFrame> getPotentialParents() {
        return null;
    }

    @Override
    protected int singleHash() {
        return this.specialType > 0 && this.environmentName != null ? this.environmentName.hashCode() : (int)this.handle;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof REnvironment) {
            REnvironment other = (REnvironment)obj;
            return this.specialType == other.getSpecialType() && Objects.equals(this.environmentName, other.getEnvironmentName());
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RObject type=environment, class=").append(this.getRClassName());
        sb.append("\n\tlength=").append(this.length);
        if (this.components != null) {
            sb.append("\n\tdata: ");
            int i = 0;
            while (i < this.length) {
                sb.append("\n$").append(this.namesAttribute.getChar(i)).append("\n");
                sb.append(this.components[i]);
                ++i;
            }
        } else {
            sb.append("\n<NODATA/>");
        }
        return sb.toString();
    }
}

