/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection.action;

import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.coordinate.LPoint;
import org.eclipse.statet.ecommons.waltable.selection.SelectCellCommand;
import org.eclipse.statet.ecommons.waltable.ui.action.IDragMode;
import org.eclipse.swt.events.MouseEvent;

public class CellSelectionDragMode
implements IDragMode {
    private LPoint lastDragInCellPosition = null;

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.lastDragInCellPosition = new LPoint(natTable.getColumnPositionByX(event.x), natTable.getRowPositionByY(event.y));
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        if ((long)event.x > natTable.getWidth()) {
            return;
        }
        long selectedColumnPosition = natTable.getColumnPositionByX(event.x);
        long selectedRowPosition = natTable.getRowPositionByY(event.y);
        if (selectedColumnPosition > -1L && selectedRowPosition > -1L) {
            LPoint dragInCellPosition = new LPoint(selectedColumnPosition, selectedRowPosition);
            if (this.lastDragInCellPosition == null || !dragInCellPosition.equals(this.lastDragInCellPosition)) {
                this.lastDragInCellPosition = dragInCellPosition;
                this.fireSelectionCommand(natTable, selectedColumnPosition, selectedRowPosition, 131072);
            }
        }
    }

    protected void fireSelectionCommand(NatTable natTable, long columnPosition, long rowPosition, int selectionFlags) {
        natTable.doCommand(new SelectCellCommand(natTable, columnPosition, rowPosition, selectionFlags));
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        this.endDrag();
    }

    private void endDrag() {
        this.lastDragInCellPosition = null;
    }
}

