/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.replication.slave;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.log.LogFactory;
import org.apache.derby.iapi.store.replication.slave.SlaveFactory;
import org.apache.derby.impl.store.raw.log.LogCounter;
import org.apache.derby.impl.store.raw.log.LogToFile;
import org.apache.derby.impl.store.replication.ReplicationLogger;
import org.apache.derby.impl.store.replication.net.ReplicationMessage;
import org.apache.derby.impl.store.replication.net.ReplicationMessageReceive;
import org.apache.derby.impl.store.replication.net.SlaveAddress;
import org.apache.derby.impl.store.replication.slave.ReplicationLogScan;

public class SlaveController
implements SlaveFactory,
ModuleControl,
ModuleSupportable {
    private static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private RawStoreFactory rawStoreFactory;
    private LogToFile logToFile;
    private ReplicationMessageReceive receiver;
    private ReplicationLogger repLogger;
    private SlaveAddress slaveAddr;
    private String dbname;
    private volatile long highestLogInstant = -1L;
    private volatile boolean inReplicationSlaveMode = true;
    private volatile boolean startupSuccessful = false;
    private ReplicationLogScan logScan;
    private SlaveLogReceiverThread logReceiverThread;

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        String string = properties.getProperty("slavePort");
        try {
            int n = -1;
            if (string != null) {
                n = new Integer(string);
            }
            this.slaveAddr = new SlaveAddress(properties.getProperty("slaveHost"), n);
        }
        catch (UnknownHostException unknownHostException) {
            throw StandardException.newException("XRE04.C.1", unknownHostException, this.dbname, this.getHostName(), String.valueOf(this.getPortNumber()));
        }
        this.dbname = properties.getProperty("replication.slave.dbname");
        this.repLogger = new ReplicationLogger(this.dbname);
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode) {
            try {
                this.stopSlave(true);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canSupport(Properties properties) {
        String string = properties.getProperty("replication.slave.mode");
        return string != null && string.equals("slavemode");
    }

    @Override
    public void startSlave(RawStoreFactory rawStoreFactory, LogFactory logFactory) throws StandardException {
        this.rawStoreFactory = rawStoreFactory;
        try {
            this.logToFile = (LogToFile)logFactory;
        }
        catch (ClassCastException classCastException) {
            throw StandardException.newException("XRE00", new Object[0]);
        }
        this.logToFile.initializeReplicationSlaveRole();
        this.receiver = new ReplicationMessageReceive(this.slaveAddr, this.dbname);
        while (!this.setupConnection()) {
            if (this.inReplicationSlaveMode) continue;
            return;
        }
        this.logScan = new ReplicationLogScan();
        this.startLogReceiverThread();
        this.startupSuccessful = true;
        Monitor.logTextMessage("R003", this.dbname);
    }

    private void stopSlave() throws StandardException {
        this.inReplicationSlaveMode = false;
        this.teardownNetwork();
        this.logToFile.stopReplicationSlaveRole();
        Monitor.logTextMessage("R004", this.dbname);
    }

    @Override
    public void stopSlave(boolean bl) throws StandardException {
        if (!bl && this.isConnectedToMaster()) {
            throw StandardException.newException("XRE41.C", new Object[0]);
        }
        this.stopSlave();
    }

    @Override
    public void failover() throws StandardException {
        if (this.isConnectedToMaster()) {
            throw StandardException.newException("XRE41.C", new Object[0]);
        }
        this.doFailover();
        this.teardownNetwork();
    }

    private void doFailover() {
        this.inReplicationSlaveMode = false;
        this.logToFile.failoverSlave();
        Monitor.logTextMessage("R020", this.dbname);
    }

    @Override
    public boolean isStarted() {
        return this.startupSuccessful;
    }

    private boolean setupConnection() throws StandardException {
        try {
            if (this.highestLogInstant != -1L) {
                this.receiver.initConnection(1000, this.highestLogInstant, this.dbname);
            } else {
                this.receiver.initConnection(1000, this.logToFile.getFirstUnflushedInstantAsLong(), this.dbname);
            }
            return true;
        }
        catch (StandardException standardException) {
            throw standardException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            return false;
        }
        catch (Exception exception) {
            throw StandardException.newException("XRE04.C.1", exception, this.dbname, this.getHostName(), String.valueOf(this.getPortNumber()));
        }
    }

    private void handleDisconnect(Exception exception) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R006", exception);
        try {
            while (!this.setupConnection()) {
                if (this.inReplicationSlaveMode) continue;
                return;
            }
            this.startLogReceiverThread();
        }
        catch (StandardException standardException) {
            this.handleFatalException(standardException);
        }
    }

    private boolean isConnectedToMaster() {
        if (this.receiver == null) {
            return false;
        }
        return this.receiver.isConnectedToMaster();
    }

    private void startLogReceiverThread() {
        this.logReceiverThread = new SlaveLogReceiverThread();
        this.logReceiverThread.setDaemon(true);
        this.logReceiverThread.start();
    }

    private void handleFatalException(Exception exception) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R005", exception);
        try {
            this.stopSlave();
        }
        catch (StandardException standardException) {
            this.repLogger.logError("R005", standardException);
        }
    }

    private void teardownNetwork() {
        try {
            if (this.receiver != null) {
                this.receiver.tearDown();
                this.receiver = null;
            }
        }
        catch (IOException iOException) {
            this.repLogger.logError(null, iOException);
        }
    }

    private String getHostName() {
        return this.slaveAddr.getHostAddress().getHostName();
    }

    private int getPortNumber() {
        return this.slaveAddr.getPortNumber();
    }

    private class SlaveLogReceiverThread
    extends Thread {
        SlaveLogReceiverThread() {
            super("derby.slave.logger-" + SlaveController.this.dbname);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                block9: while (SlaveController.this.inReplicationSlaveMode) {
                    ReplicationMessage replicationMessage = SlaveController.this.receiver.readMessage();
                    switch (replicationMessage.getType()) {
                        case 10: {
                            byte[] byArray = (byte[])replicationMessage.getMessage();
                            this.handleLogChunk(byArray);
                            continue block9;
                        }
                        case 21: {
                            SlaveController.this.doFailover();
                            ReplicationMessage replicationMessage2 = new ReplicationMessage(11, "failover succeeded");
                            SlaveController.this.receiver.sendMessage(replicationMessage2);
                            SlaveController.this.teardownNetwork();
                            continue block9;
                        }
                        case 20: {
                            SlaveController.this.stopSlave();
                            continue block9;
                        }
                    }
                    System.out.println("Not handling non-log messages yet - got a type " + replicationMessage.getType());
                }
                return;
            }
            catch (EOFException eOFException) {
                SlaveController.this.handleDisconnect(eOFException);
                return;
            }
            catch (StandardException standardException) {
                SlaveController.this.handleFatalException(standardException);
                return;
            }
            catch (Exception exception) {
                StandardException standardException = StandardException.newException("XRE03", exception, new Object[0]);
                SlaveController.this.handleFatalException(standardException);
            }
        }

        private void handleLogChunk(byte[] byArray) throws StandardException {
            SlaveController.this.logScan.init(byArray);
            while (SlaveController.this.logScan.next()) {
                if (SlaveController.this.logScan.isLogFileSwitch()) {
                    SlaveController.this.logToFile.switchLogFile();
                    continue;
                }
                long l = SlaveController.this.logToFile.appendLogRecord(SlaveController.this.logScan.getData(), 0, SlaveController.this.logScan.getDataLength(), null, 0, 0);
                if (SlaveController.this.logScan.getInstant() != l) {
                    throw StandardException.newException("XRE05.C", SlaveController.this.dbname, new Long(LogCounter.getLogFileNumber(SlaveController.this.logScan.getInstant())), new Long(LogCounter.getLogFilePosition(SlaveController.this.logScan.getInstant())), new Long(LogCounter.getLogFileNumber(l)), new Long(LogCounter.getLogFilePosition(l)));
                }
                SlaveController.this.highestLogInstant = l;
            }
        }
    }
}

