/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.mpbv;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.statet.ecommons.ui.mpbv.BrowserBookmark;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class EditBookmarkDialog
extends Dialog {
    private Text nameControl;
    private Text urlControl;
    private BrowserBookmark bookmark;

    public EditBookmarkDialog(Shell parentShell, BrowserBookmark bookmark) {
        super(parentShell);
        this.bookmark = bookmark;
        this.create();
    }

    protected void configureShell(Shell shell) {
        shell.setText("Edit Bookmark");
        super.configureShell(shell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid(2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Name:");
        Text text = new Text(composite, 2048);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth(text, 80);
        text.setLayoutData((Object)gd);
        this.nameControl = text;
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&URL:");
        text = new Text(composite, 18432);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.urlControl = text;
        if (this.bookmark != null) {
            this.nameControl.setText(this.bookmark.getLabel());
            this.urlControl.setText(this.bookmark.getUrl());
        }
        EditBookmarkDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        this.bookmark = new BrowserBookmark(this.nameControl.getText(), this.urlControl.getText());
        super.okPressed();
    }

    public BrowserBookmark getBookmark() {
        return this.bookmark;
    }
}

