/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ide.core;

import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.statet.internal.ide.core.SshSessionManager;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

public final class BaseCorePlugin
extends Plugin {
    private static BaseCorePlugin instance;
    private boolean started;
    private final CopyOnWriteArraySet<Disposable> disposables = new CopyOnWriteArraySet();
    private ServiceTracker sshTracker;
    private SshSessionManager sshSessions;
    private static final Version REQ_JSCH_VERSION;

    static {
        REQ_JSCH_VERSION = new Version(0, 1, 49);
    }

    public static BaseCorePlugin getInstance() {
        return instance;
    }

    public BaseCorePlugin() {
        instance = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.sshTracker = new ServiceTracker(context, "org.eclipse.jsch.core.IJSchService", null);
        this.sshTracker.open();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            BaseCorePlugin baseCorePlugin = this;
            synchronized (baseCorePlugin) {
                this.started = false;
                this.sshSessions = null;
            }
            try {
                for (Disposable listener : this.disposables) {
                    listener.dispose();
                }
            }
            finally {
                this.disposables.clear();
            }
            if (this.sshTracker != null) {
                this.sshTracker.close();
                this.sshTracker = null;
            }
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    public void addStopListener(Disposable listener) {
        this.disposables.add(listener);
    }

    public void removeStopListener(Disposable listener) {
        this.disposables.remove(listener);
    }

    public IJSchService getJSchService() throws CoreException {
        IJSchService.class.getName();
        Bundle bundle = Platform.getBundle((String)"com.jcraft.jsch");
        if (bundle != null && bundle.getVersion().compareTo(REQ_JSCH_VERSION) < 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ide.core", 0, "The installed version of the Java Secure Channel Library 'JSch' by JCraft is outdated.\nPlease install version " + REQ_JSCH_VERSION + " or newer, " + "for example from the update-site of WalWare.de.", null));
        }
        return (IJSchService)this.sshTracker.getService();
    }

    public synchronized SshSessionManager getSshSessionManager() {
        if (this.sshSessions == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.sshSessions = new SshSessionManager();
            this.addStopListener(this.sshSessions);
        }
        return this.sshSessions;
    }
}

