/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.model;

import org.eclipse.statet.docmlet.tex.core.model.TexElementName;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceElement;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;

@NonNullByDefault
public abstract class BasicLtxSourceElement
implements TexSourceElement,
TextRegion {
    protected static final ImList<BasicLtxSourceElement> NO_CHILDREN = ImCollections.emptyList();
    private final int type;
    protected TexElementName name;
    protected int occurrenceCount;
    protected int startOffset;
    protected int length;

    protected BasicLtxSourceElement(int type) {
        this.type = type;
    }

    public final String getModelTypeId() {
        return "Ltx";
    }

    public final int getElementType() {
        return this.type;
    }

    public String getId() {
        String name = this.getElementName().getDisplayName();
        StringBuilder sb = new StringBuilder(name.length() + 16);
        sb.append(Integer.toHexString(this.type & 0xFF0));
        sb.append(':');
        sb.append(name);
        sb.append('#');
        sb.append(this.occurrenceCount);
        return sb.toString();
    }

    public ElementName getElementName() {
        return this.name;
    }

    public TextRegion getSourceRange() {
        return this;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.startOffset + this.length;
    }

    public int getLength() {
        return this.length;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        return null;
    }

    public int hashCode() {
        return (this.type & 0xFF0) * this.getElementName().hashCode() + this.occurrenceCount;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicLtxSourceElement) {
            BasicLtxSourceElement other = (BasicLtxSourceElement)obj;
            return (this.type & 0xFF0) == (other.type & 0xFF0) && this.occurrenceCount == other.occurrenceCount && ((this.type & 0xF00) == 512 || this.getSourceParent().equals(other.getSourceParent())) && this.getElementName().equals(other.getElementName());
        }
        return false;
    }
}

