/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class DocFieldVisitorCollector
extends SimpleCollector {
    private final Visitor visitor;
    private Scorer scorer;
    private LeafReader reader;
    private LeafReader readerSet;

    public DocFieldVisitorCollector(Visitor visitor) {
        this.visitor = visitor;
    }

    public boolean needsScores() {
        return true;
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.reader = context.reader();
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public void collect(int doc) throws IOException {
        float score = this.scorer.score();
        if (score > 0.0f) {
            if (this.readerSet != this.reader) {
                this.readerSet = this.reader;
                this.visitor.setReader(this.readerSet);
            }
            this.visitor.newDocMatch(doc, score);
            this.reader.document(doc, (StoredFieldVisitor)this.visitor);
            this.visitor.finalizeDocMatch();
        }
    }

    public static abstract class Visitor
    extends StoredFieldVisitor {
        private final Set<String> fieldNames;

        public Visitor(Set<String> fieldNames) {
            this.fieldNames = fieldNames;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return this.fieldNames.contains(fieldInfo.name) ? StoredFieldVisitor.Status.YES : StoredFieldVisitor.Status.NO;
        }

        public void setReader(LeafReader reader) throws IOException {
        }

        public abstract void newDocMatch(int var1, float var2) throws IOException;

        public abstract void finalizeDocMatch() throws IOException;
    }
}

