/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.rmi;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.rmi.RMIRegistry;

@NonNullByDefault
public class RMIAddress {
    private static final int DEFAULT_PORT_NUM = 1099;
    public static final Port DEFAULT_PORT = new Port(1099);
    public static final String REGISTRY_NAME = "";
    private final @Nullable String host;
    private InetAddress hostAddress;
    private final Port port;
    private final boolean isSsl;
    private final String path;
    private @Nullable String address;
    private @Nullable String ser;

    public static void validate(String address) throws MalformedURLException {
        try {
            new RMIAddress(address, false);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private static String checkChars(String s) throws MalformedURLException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '?' || c == '#' || c == '[' || c == ']' || c == '@' || c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=' || c == '\"' || c == '\\') {
                throw new MalformedURLException("Character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    private static String checkNameChars(String s) throws IllegalArgumentException {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '?' || c == '#' || c == '[' || c == ']' || c == '@' || c == '!' || c == '$' || c == '&' || c == '\'' || c == '(' || c == ')' || c == '*' || c == '+' || c == ',' || c == ';' || c == '=' || c == '\"' || c == '\\') {
                throw new IllegalArgumentException("Character '" + c + "' is not allowed.");
            }
            ++i;
        }
        return s;
    }

    private static Port parsePort(String port) throws MalformedURLException {
        try {
            return Port.valueOf(port);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedURLException("Invalid port: " + e.getLocalizedMessage());
        }
    }

    private static Port checkPort(Port port) {
        return port.get() == 1099 ? DEFAULT_PORT : port;
    }

    private static String build(@Nullable String host, int portNum, @Nullable String name) {
        StringBuilder sb = new StringBuilder("//");
        if (host != null) {
            sb.append(host);
        }
        sb.append(':');
        if (portNum >= 0) {
            sb.append(Integer.toString(portNum));
        }
        sb.append('/');
        if (name != null) {
            sb.append(name);
        }
        return sb.toString();
    }

    public RMIAddress(String address) throws UnknownHostException, MalformedURLException {
        this(address, true);
    }

    public RMIAddress(@Nullable String host, int portNum, @Nullable String name) throws UnknownHostException, MalformedURLException {
        this(RMIAddress.build(host, portNum, name), true);
    }

    public RMIAddress(InetAddress address, int portNum, @Nullable String name) throws MalformedURLException {
        this(address.getHostAddress(), address, RMIAddress.parsePort(Integer.toString(portNum)), false, name != null ? RMIAddress.checkChars(name) : REGISTRY_NAME);
    }

    public RMIAddress(InetAddress address, Port port, boolean isSsl, String name) {
        this(address.getHostAddress(), address, RMIAddress.checkPort(port), isSsl, RMIAddress.checkNameChars(name));
    }

    public RMIAddress(InetAddress address, Port port, String name) {
        this(address.getHostAddress(), address, RMIAddress.checkPort(port), false, RMIAddress.checkNameChars(name));
    }

    public RMIAddress(RMIAddress registry, String name) {
        this(registry.host, registry.hostAddress, registry.port, registry.isSsl, RMIAddress.checkNameChars(name));
    }

    private RMIAddress(String address, boolean resolve) throws UnknownHostException, MalformedURLException {
        address = RMIAddress.checkChars(address);
        if (address.startsWith("ssl:")) {
            address = address.substring(4);
            this.isSsl = true;
        } else {
            this.isSsl = false;
        }
        if (address.startsWith("rmi:")) {
            address = address.substring(4);
        }
        if (!address.startsWith("//")) {
            address = "//" + address;
        }
        int idxPort = address.indexOf(58, 2);
        int idxPath = address.indexOf(47, 2);
        if (idxPort > 0) {
            if (idxPath <= idxPort) {
                throw new IllegalArgumentException();
            }
            this.host = 2 < idxPort ? address.substring(2, idxPort) : null;
            this.port = idxPort + 1 < idxPath ? RMIAddress.checkPort(RMIAddress.parsePort(address.substring(idxPort + 1, idxPath))) : DEFAULT_PORT;
            this.path = address.substring(idxPath + 1);
        } else if (idxPath > 0) {
            this.host = 2 < idxPath ? address.substring(2, idxPath) : null;
            this.port = DEFAULT_PORT;
            this.path = address.substring(idxPath + 1);
        } else {
            this.host = null;
            this.port = DEFAULT_PORT;
            this.path = address.substring(2);
        }
        if (resolve) {
            this.hostAddress = this.host != null ? InetAddress.getByName(this.host) : InetAddress.getLoopbackAddress();
        }
    }

    private RMIAddress(@Nullable String host, InetAddress hostAddress, Port port, boolean isSsl, String path) {
        this.host = host;
        this.hostAddress = hostAddress;
        this.port = port;
        this.isSsl = isSsl;
        this.path = path;
    }

    public String getHost() {
        return this.host != null ? this.host : this.hostAddress.getHostAddress();
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public boolean isLocalHost() {
        if (this.hostAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            if (this.hostAddress.equals(localhost)) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return false;
    }

    public Port getPort() {
        return this.port;
    }

    public String getName() {
        return this.path;
    }

    public String getAddress() {
        String address = this.address;
        if (address == null) {
            StringBuilder sb = new StringBuilder(32);
            sb.append("rmi://");
            if (this.host != null) {
                sb.append(this.host);
            }
            if (this.port != DEFAULT_PORT) {
                sb.append(':');
                sb.append(this.port);
            }
            sb.append('/');
            sb.append(this.path);
            this.address = address = sb.toString();
        }
        return address;
    }

    public RMIAddress getRegistryAddress() {
        return new RMIAddress(this.host, this.hostAddress, this.port, this.isSsl, REGISTRY_NAME);
    }

    public Remote lookup() throws RemoteException, NotBoundException, AccessException {
        RMIRegistry rmiRegistry = new RMIRegistry(this.getRegistryAddress(), false);
        return rmiRegistry.getRegistry().lookup(this.getName());
    }

    public boolean isSsl() {
        return this.isSsl;
    }

    public String toString() {
        String ser = this.ser;
        if (ser == null) {
            ser = this.isSsl ? "ssl:" + this.getAddress() : this.getAddress();
            this.ser = ser;
        }
        return ser;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RMIAddress) {
            RMIAddress other = (RMIAddress)obj;
            return this.hostAddress.equals(other.hostAddress) && this.port.equals(other.port) && this.isSsl == other.isSsl && this.path.equals(other.path);
        }
        return false;
    }
}

