/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHoverDescriptor;

@NonNullByDefault
public class CombinedHover
implements InfoHover {
    private List<InfoHoverDescriptor> descriptors;
    private List<InfoHover> instantiatedHovers;
    private volatile @Nullable InfoHover bestHover;

    public synchronized void setHovers(List<InfoHoverDescriptor> descriptors) {
        this.descriptors = descriptors;
        this.instantiatedHovers = new ArrayList<InfoHover>(descriptors.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Object getHoverInfo(AssistInvocationContext context, ProgressMonitor m) throws StatusException {
        List<InfoHover> instantiatedHovers;
        List<InfoHoverDescriptor> descriptors;
        this.bestHover = null;
        CombinedHover combinedHover = this;
        synchronized (combinedHover) {
            descriptors = this.descriptors;
            instantiatedHovers = this.instantiatedHovers;
        }
        if (descriptors == null) {
            return null;
        }
        int i = 0;
        while (i < descriptors.size()) {
            InfoHover hover;
            m.setWorkRemaining(descriptors.size() - i);
            if (m.isCanceled()) {
                throw new StatusException(Statuses.CANCEL_STATUS);
            }
            if (i == instantiatedHovers.size()) {
                instantiatedHovers.add(descriptors.get(i).createHover());
            }
            if ((hover = instantiatedHovers.get(i)) != null) {
                try {
                    Object info = hover.getHoverInfo(context, m.newSubMonitor(1));
                    if (info != null) {
                        this.bestHover = hover;
                        return info;
                    }
                }
                catch (StatusException statusException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public @Nullable IInformationControlCreator getHoverControlCreator() {
        InfoHover hover = this.bestHover;
        if (hover != null) {
            return hover.getHoverControlCreator();
        }
        return null;
    }
}

