/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.core.util.TextUtils;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IWorkbenchPart;

@NonNullByDefault
public abstract class InsertEditorTemplateHandler
extends AbstractHandler {
    public static final String TEMPLATE_ID_PARAMETER_ID = "templateId";

    protected abstract @Nullable TemplateCompletionComputer getComputer();

    protected AssistInvocationContext createContext(ISourceEditor editor) throws BadPartitioningException, BadLocationException {
        TextRegion region = editor.getSelectedRegion();
        String contentType = TextUtils.getContentType((IDocument)editor.getViewer().getDocument(), (DocContentSections)editor.getDocumentContentInfo(), (int)region.getStartOffset(), (boolean)true);
        return new AssistInvocationContext(editor, region, contentType, 0, null);
    }

    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        SourceEditorTemplateContext templateContext;
        AssistInvocationContext region;
        AssistInvocationContext context;
        Template template;
        TemplateCompletionComputer computer;
        block7: {
            ISourceEditor editor;
            computer = this.getComputer();
            if (computer == null) {
                return null;
            }
            String templateId = event.getParameter(TEMPLATE_ID_PARAMETER_ID);
            Template template2 = template = templateId != null ? computer.getTemplateStore().findTemplateById(templateId) : null;
            if (template == null) {
                return null;
            }
            IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
            ISourceEditor iSourceEditor = editor = activePart != null ? (ISourceEditor)activePart.getAdapter(ISourceEditor.class) : null;
            if (editor == null) {
                return null;
            }
            region = context = this.createContext(editor);
            templateContext = computer.createTemplateContext(context, region, 32, true);
            if (templateContext != null) break block7;
            return null;
        }
        try {
            TemplateProposal proposal = computer.createProposal(new TemplateProposal.TemplateProposalParameters<AssistInvocationContext>(context, (TextRegion)region, templateContext, template));
            SourceViewer viewer = context.getSourceViewer();
            proposal.apply((ITextViewer)viewer, '\u0000', 0, context.getEndOffset());
            Point selection = proposal.getSelection(null);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        catch (Exception e) {
            new ExecutionException(NLS.bind((String)"An error occurred when inserting the template ''{0}''.", (Object)template.getName()), (Throwable)e);
        }
        return null;
    }
}

