/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.gui;

import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.edit.DialogEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.gui.CellEditDialog;
import org.eclipse.statet.ecommons.waltable.edit.gui.ICellEditDialog;
import org.eclipse.statet.ecommons.waltable.edit.gui.TickUpdateCellEditDialog;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.tickupdate.ITickUpdateHandler;
import org.eclipse.statet.ecommons.waltable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CellEditDialogFactory {
    public static ICellEditDialog createCellEditDialog(Shell parentShell, Object originalCanonicalValue, ILayerCell cell, ICellEditor cellEditor, IConfigRegistry configRegistry) {
        ICellEditDialog result = null;
        if (cellEditor instanceof ICellEditDialog) {
            cellEditor.activateCell((Composite)parentShell, originalCanonicalValue, EditMode.DIALOG, new DialogEditHandler(), cell, configRegistry);
            result = (ICellEditDialog)((Object)cellEditor);
        } else {
            ITickUpdateHandler tickUpdateHandler = configRegistry.getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, DisplayMode.EDIT, cell.getConfigLabels().getLabels());
            result = tickUpdateHandler != null && tickUpdateHandler.isApplicableFor(cell.getDataValue(0, null)) ? new TickUpdateCellEditDialog(parentShell, originalCanonicalValue, cell, cellEditor, configRegistry, tickUpdateHandler) : new CellEditDialog(parentShell, originalCanonicalValue, cell, cellEditor, configRegistry);
        }
        result.setDialogSettings(configRegistry.getConfigAttribute(EditConfigAttributes.EDIT_DIALOG_SETTINGS, DisplayMode.EDIT, cell.getConfigLabels().getLabels()));
        return result;
    }
}

