/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.style;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.style.ConfigAttribute;
import org.eclipse.statet.ecommons.waltable.style.DisplayMode;
import org.eclipse.statet.ecommons.waltable.style.IDisplayModeLookupStrategy;
import org.eclipse.statet.ecommons.waltable.style.IStyle;

public abstract class StyleProxy
implements IStyle {
    private final ConfigAttribute<IStyle> styleConfigAttribute;
    private final IConfigRegistry configRegistry;
    private final DisplayMode targetDisplayMode;
    private final List<String> configLabels;

    public StyleProxy(ConfigAttribute<IStyle> styleConfigAttribute, IConfigRegistry configRegistry, DisplayMode targetDisplayMode, List<String> configLabels) {
        this.styleConfigAttribute = styleConfigAttribute;
        this.configRegistry = configRegistry;
        this.targetDisplayMode = targetDisplayMode;
        this.configLabels = configLabels;
    }

    @Override
    public <T> T getAttributeValue(ConfigAttribute<T> styleAttribute) {
        T styleAttributeValue = null;
        IDisplayModeLookupStrategy displayModeLookupStrategy = this.configRegistry.getDisplayModeOrdering();
        for (DisplayMode displayMode : displayModeLookupStrategy.getDisplayModeOrdering(this.targetDisplayMode)) {
            for (String configLabel : this.configLabels) {
                IStyle cellStyle = this.configRegistry.getSpecificConfigAttribute(this.styleConfigAttribute, displayMode, configLabel);
                if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
                return styleAttributeValue;
            }
            IStyle cellStyle = this.configRegistry.getSpecificConfigAttribute(this.styleConfigAttribute, displayMode, null);
            if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
            return styleAttributeValue;
        }
        return null;
    }
}

