/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.renv.core;

import java.util.Comparator;
import org.eclipse.statet.jcommons.collections.SortedArraySet;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.core.RPkgUtils;

@NonNullByDefault
public final class BasicRPkgList<T extends @NonNull RPkg>
extends SortedArraySet<T>
implements RPkgList<T> {
    private static final Comparator<RPkg> RPKG_BY_NAME_COMPARATOR = new Comparator<RPkg>(){

        @Override
        public final int compare(RPkg pkg1, RPkg pkg2) {
            return RPkgUtils.NAMES_COLLATOR.compare(pkg1.getName(), pkg2.getName());
        }
    };
    private static final long serialVersionUID = -3022375551268568786L;

    public BasicRPkgList(int capacity) {
        super((Object[])new RPkg[capacity], 0, RPKG_BY_NAME_COMPARATOR);
    }

    @Override
    public int indexOf(@Nullable String name) {
        if (name == null) {
            return -1;
        }
        int low = 0;
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((RPkg)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(String name, int low) {
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((RPkg)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOfE(T element) {
        return this.indexOf(element.getName());
    }

    @Override
    public boolean contains(@Nullable String name) {
        return this.indexOf(name) >= 0;
    }

    @Override
    public @Nullable T get(@Nullable String name) {
        int idx = this.indexOf(name);
        return (T)(idx >= 0 ? (RPkg)super.get(idx) : null);
    }

    public int addE(T pkg) {
        return this.addIndex(this.indexOf(pkg.getName()), pkg);
    }

    public void add(int index, T element) {
        super.add(index, (Object)((RPkg)ObjectUtils.nonNullAssert(element)));
    }

    public void remove(String name) {
        int idx = this.indexOf(name);
        if (idx >= 0) {
            this.remove(idx);
        }
    }
}

