/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class FilterLineSequence
extends LineSequence {
    private static final Line STOP = new Line(0, 0, 0, "<STOP>", "\n");
    private final LineSequence delegate;
    private @Nullable Line filteredLine;

    public FilterLineSequence(LineSequence delegate) {
        this.delegate = delegate;
    }

    protected final LineSequence getDelegate() {
        return this.delegate;
    }

    @Override
    public @Nullable Line getCurrentLine() {
        if (this.filteredLine == null) {
            Line line = this.delegate.getCurrentLine();
            if (line != null) {
                line = this.filter(line);
            }
            this.filteredLine = line != null ? line : STOP;
        }
        return this.filteredLine != STOP ? this.filteredLine : null;
    }

    @Override
    public @Nullable Line getNextLine() {
        Line line = this.delegate.getNextLine();
        if (line != null) {
            return this.filter(line);
        }
        return null;
    }

    @Override
    public void advance() {
        this.delegate.advance();
        this.filteredLine = null;
    }

    protected abstract @Nullable Line filter(Line var1);
}

