/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.List;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Emphasis;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Strong;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class PotentialStyleDelimiterInfo {
    public static final byte FLANKING = 1;
    public static final byte FLANKING_UNDERSCORE = 2;
    public static final byte NO_SPACE = 16;
    static final PotentialStyleDelimiterInfo DEFAULT_ASTERISK = new EmphasisDelimiter(){

        @Override
        public char getChar() {
            return '*';
        }

        @Override
        public byte getRequirements(int size) {
            return 1;
        }
    };
    static final PotentialStyleDelimiterInfo DEFAULT_UNDERSCORE = new EmphasisDelimiter(){

        @Override
        public char getChar() {
            return '_';
        }

        @Override
        public byte getRequirements(int size) {
            return 2;
        }
    };

    public abstract char getChar();

    public abstract boolean isPotentialSequence(int var1);

    public int getSize(int openingLength, int closingLength) {
        int min = Math.min(openingLength, closingLength);
        if (min <= 2) {
            return min;
        }
        return 2;
    }

    public abstract byte getRequirements(int var1);

    public abstract Inline createStyleInline(int var1, Line var2, int var3, int var4, List<Inline> var5);

    public String toString() {
        return "DelimiterInfo '" + this.getChar() + "'";
    }

    static abstract class EmphasisDelimiter
    extends PotentialStyleDelimiterInfo {
        EmphasisDelimiter() {
        }

        @Override
        public boolean isPotentialSequence(int length) {
            return true;
        }

        @Override
        public Inline createStyleInline(int size, Line line, int offset, int length, List<Inline> contents) {
            switch (size) {
                case 1: {
                    return new Emphasis(line, offset, length, contents);
                }
                case 2: {
                    return new Strong(line, offset, length, contents);
                }
            }
            throw new IllegalStateException();
        }
    }

    static abstract class ExtDelimiter
    extends PotentialStyleDelimiterInfo {
        private final byte flags;

        public ExtDelimiter(boolean size1, boolean size2) {
            byte f = 0;
            if (size1) {
                f = (byte)(f | 1);
            }
            if (size2) {
                f = (byte)(f | 2);
            }
            if (f == 0) {
                throw new IllegalArgumentException();
            }
            this.flags = f;
        }

        @Override
        public boolean isPotentialSequence(int length) {
            switch (this.flags & 3) {
                case 2: {
                    return length >= 2;
                }
            }
            return true;
        }

        @Override
        public int getSize(int openingLength, int closingLength) {
            switch (this.flags & 3) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
            return super.getSize(openingLength, closingLength);
        }

        @Override
        public byte getRequirements(int size) {
            return size == 1 ? (byte)16 : 1;
        }
    }
}

